"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resourceStats = exports.forEachNamespaced = exports.forEachProvider = exports.forEachImport = exports.forEachGlobal = void 0;
const telemetryAllowList_json_1 = require("./telemetryAllowList.json");
// locals, variables, and outputs are global key value maps
function forEachGlobal(scope, prefix, record, iterator) {
    return Object.entries(record || {}).reduce((carry, [key, item]) => {
        const id = `${prefix}.${key}`;
        return {
            ...carry,
            [id]: {
                code: async (graph) => await iterator(scope, key, id, item, graph),
                value: item,
            },
        };
    }, {});
}
exports.forEachGlobal = forEachGlobal;
function forEachImport(scope, prefix, record, iterator) {
    return (record || []).reduce((carry, item) => {
        const target = item.to.startsWith("${") && item.to.endsWith("}")
            ? item.to.substring(2, item.to.length - 1)
            : item.to;
        const id = `${prefix}.${target}`;
        return {
            ...carry,
            [id]: {
                code: async (graph) => await iterator(scope, id, item, graph),
                value: item,
            },
        };
    }, {});
}
exports.forEachImport = forEachImport;
function forEachProvider(scope, record, iterator) {
    return Object.entries(record || {}).reduce((carry, [key, items]) => {
        return {
            ...carry,
            ...items.reduce((innerCarry, item) => {
                const id = item.alias ? `${key}.${item.alias}` : `${key}`;
                return {
                    ...innerCarry,
                    [id]: {
                        code: async (graph) => await iterator(scope, key, id, item, graph),
                        value: item,
                    },
                };
            }, {}),
        };
    }, {});
}
exports.forEachProvider = forEachProvider;
// data and resource are namespaced key value maps
function forEachNamespaced(scope, record, iterator, prefix) {
    return Object.entries(record || {}).reduce((outerCarry, [type, items]) => ({
        ...outerCarry,
        ...Object.entries(items).reduce((innerCarry, [key, item]) => {
            const prefixedType = prefix ? `${prefix}.${type}` : type;
            const id = prefix ? `${prefix}.${type}.${key}` : `${type}.${key}`;
            return {
                ...innerCarry,
                [id]: {
                    code: async (graph) => await iterator(scope, prefixedType, key, id, item, graph),
                    value: item,
                },
            };
        }, {}),
    }), {});
}
exports.forEachNamespaced = forEachNamespaced;
function resourceStats(obj) {
    return Object.entries(obj).reduce((carry, [key, value]) => {
        const [provider, ...resourceParts] = key.split("_");
        const shouldBeTracked = telemetryAllowList_json_1.providers.includes(provider);
        const providerKey = shouldBeTracked ? provider : "other";
        const resourceName = shouldBeTracked ? resourceParts.join("_") : "other";
        return {
            ...carry,
            [providerKey]: {
                ...(carry[providerKey] || {}),
                [resourceName]: Object.keys(value).length,
            },
        };
    }, {});
}
exports.resourceStats = resourceStats;
//# sourceMappingURL=data:application/json;base64,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