import { DirectedGraph } from "graphology";
import { ProgramScope } from "./types";
import { Import } from "./schema";
export declare function forEachGlobal<T, R>(scope: ProgramScope, prefix: string, record: Record<string, T> | undefined, iterator: (scope: ProgramScope, key: string, id: string, value: T, graph: DirectedGraph) => Promise<R>): Record<string, {
    code: (graph: DirectedGraph) => Promise<R>;
    value: T;
}>;
export declare function forEachImport<R>(scope: ProgramScope, prefix: string, record: Import[] | undefined, iterator: (scope: ProgramScope, id: string, value: Import, graph: DirectedGraph) => Promise<R>): Record<string, {
    code: (graph: DirectedGraph) => Promise<R>;
    value: Import;
}>;
export declare function forEachProvider<T extends {
    alias?: string;
}, R>(scope: ProgramScope, record: Record<string, T[]> | undefined, iterator: (scope: ProgramScope, key: string, id: string, value: T, graph: DirectedGraph) => Promise<R>): Record<string, {
    code: (graph: DirectedGraph) => Promise<R>;
    value: T;
}>;
export declare function forEachNamespaced<T, R>(scope: ProgramScope, record: Record<string, Record<string, T>> | undefined, iterator: (scope: ProgramScope, type: string, key: string, id: string, value: T, graph: DirectedGraph) => Promise<R>, prefix?: string): Record<string, {
    code: (graph: DirectedGraph) => Promise<R>;
    value: T;
}>;
export declare function resourceStats(obj: Record<string, Record<string, unknown>>): Record<string, Record<string, number>>;
//# sourceMappingURL=iteration.d.ts.map