import { isRegistryModule } from "@cdktf/provider-generator";
import * as rosetta from "jsii-rosetta";
import * as z from "zod";
import { attributeNameToCdktfName } from "./generation";
import { replaceCsharpImports, replaceGoImports, replaceJavaImports, replacePythonImports } from "./jsii-rosetta-workarounds";
import { ProviderSchema } from "@cdktf/commons";
export declare const CODE_MARKER = "// define resources here";
export declare function getParsedHcl(hcl: string): Promise<{
    terraform?: {
        backend?: Record<string, Record<string, any>[]> | undefined;
        required_providers?: Record<string, string | {
            source?: string | undefined;
            version?: string | undefined;
        }>[] | undefined;
        required_version?: string | undefined;
    }[] | undefined;
    provider?: Record<string, Record<string, any>[]> | undefined;
    module?: Record<string, z.objectOutputType<{
        source: z.ZodString;
    }, z.ZodTypeAny, "passthrough">[]> | undefined;
    resource?: Record<string, Record<string, Record<string, any>[]>> | undefined;
    data?: Record<string, Record<string, Record<string, any>[]>> | undefined;
    output?: Record<string, {
        value?: any;
        description?: string | undefined;
        sensitive?: boolean | undefined;
        depends_on?: string | undefined;
    }[]> | undefined;
    variable?: Record<string, {
        type?: string | undefined;
        default?: any;
        description?: string | undefined;
        sensitive?: boolean | undefined;
        nullable?: boolean | undefined;
        validation?: {
            error_message: string;
            condition?: any;
        }[] | undefined;
    }[]> | undefined;
    import?: {
        to: string;
        id: string;
        provider?: any;
    }[] | undefined;
    locals?: Record<string, any>[] | undefined;
}>;
export declare function parseProviderRequirements(hcl: string): Promise<Record<string, string>>;
export declare function convertToTypescript(hcl: string, providerSchema: ProviderSchema, codeContainer: string): Promise<{
    all: string;
    imports: string;
    code: string;
    providers: string[];
    modules: string[];
    stats: {
        numberOfModules: number;
        numberOfProviders: number;
        resources: Record<string, Record<string, number>>;
        data: Record<string, Record<string, number>>;
        convertedLines: number;
    };
}>;
declare const translators: {
    python: {
        visitor: () => rosetta.PythonVisitor;
        postTranslationMutation: typeof replacePythonImports;
    };
    java: {
        visitor: () => rosetta.JavaVisitor;
        postTranslationMutation: typeof replaceJavaImports;
    };
    csharp: {
        visitor: () => rosetta.CSharpVisitor;
        postTranslationMutation: typeof replaceCsharpImports;
    };
    go: {
        visitor: () => rosetta.GoVisitor;
        postTranslationMutation: typeof replaceGoImports;
    };
};
type ConvertOptions = {
    /**
     * The language to convert to
     */
    language: keyof typeof translators | "typescript";
    /**
     * The provider schema to use for conversion
     */
    providerSchema: ProviderSchema;
    /**
     * The base class to extend from. Defaults to `constructs.Construct`
     */
    codeContainer?: string;
    /**
     * Whether to throw an error if the translation fails
     * Defaults to false
     */
    throwOnTranslationError?: boolean;
};
export declare function convert(hcl: string, { language, providerSchema, throwOnTranslationError, codeContainer, }: ConvertOptions): Promise<{
    all: string;
    imports: string;
    code: string;
    stats: {
        language: "typescript" | "python" | "csharp" | "java" | "go";
        numberOfModules: number;
        numberOfProviders: number;
        resources: Record<string, Record<string, number>>;
        data: Record<string, Record<string, number>>;
        convertedLines: number;
    };
    providers: string[];
    modules: string[];
}>;
export declare function getTerraformConfigFromDir(importPath: string): string;
type CdktfJson = Record<string, unknown> & {
    terraformProviders: any[];
    terraformModules: any[];
};
export declare function convertProject(combinedHcl: string, { language, providerSchema }: ConvertOptions): Promise<{
    code: (inputMainFile: string) => string;
    cdktfJson: (inputCdktfJson: CdktfJson) => {
        [x: string]: unknown;
        terraformProviders: any[];
        terraformModules: any[];
    };
    stats: {
        language: "typescript" | "python" | "csharp" | "java" | "go";
        numberOfModules: number;
        numberOfProviders: number;
        resources: Record<string, Record<string, number>>;
        data: Record<string, Record<string, number>>;
        convertedLines: number;
    };
}>;
export { isRegistryModule, attributeNameToCdktfName };
//# sourceMappingURL=index.d.ts.map