"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateConfigType = exports.buildImports = exports.providerConstructImports = exports.wrapCodeInConstructor = exports.addImportForCodeContainer = exports.gen = exports.moduleImports = exports.providerImports = exports.constructsImport = exports.cdktfImport = exports.provider = exports.imports = exports.modules = exports.local = exports.variable = exports.variableTypeToAst = exports.output = exports.resource = exports.backendToExpression = exports.valueToTs = exports.attributeNameToCdktfName = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const generator_1 = __importDefault(require("@babel/generator"));
const template_1 = __importDefault(require("@babel/template"));
const t = __importStar(require("@babel/types"));
const prettier_1 = __importDefault(require("prettier"));
const utils_1 = require("./utils");
const expressions_1 = require("./expressions");
const references_1 = require("./references");
const provider_generator_1 = require("@cdktf/provider-generator");
const terraformSchema_1 = require("./terraformSchema");
const commons_1 = require("@cdktf/commons");
const hcl2json_1 = require("@cdktf/hcl2json");
const dynamic_blocks_1 = require("./dynamic-blocks");
const variables_1 = require("./variables");
const util_1 = require("cdktf/lib/util");
const partialCode_1 = require("./partialCode");
function getReference(graph, id) {
    utils_1.logger.debug(`Finding reference for ${id}`);
    const neighbors = graph.outNeighbors(id);
    if (neighbors.length > 0) {
        utils_1.logger.debug(`Found neighbors ${neighbors} for ${id}`);
        const edge = graph.directedEdge(id, neighbors[0]);
        if (edge) {
            utils_1.logger.debug(`Found first edge ${edge} for ${id}`);
            utils_1.logger.debug(`Returning reference ${graph.getEdgeAttribute(edge, "ref")}`);
            return graph.getEdgeAttribute(edge, "ref");
        }
        else {
            utils_1.logger.debug(`Found no edge for ${id}`);
            return undefined;
        }
    }
    else {
        return undefined;
    }
}
function attributeNameToCdktfName(name) {
    return (0, provider_generator_1.escapeAttributeName)((0, utils_1.camelCase)(name));
}
exports.attributeNameToCdktfName = attributeNameToCdktfName;
const valueToTs = async (scope, item, path, isModule = false) => {
    switch (typeof item) {
        case "string":
            if ((await (0, references_1.findUsedReferences)(scope.nodeIds, item)).some((ref) => path.startsWith(ref.referencee.id))) {
                return t.stringLiteral(item);
            }
            return await (0, expressions_1.convertTerraformExpressionToTs)(scope, `"${item}"`, () => (0, terraformSchema_1.getDesiredType)(scope, path));
        case "boolean":
            return await (0, expressions_1.convertTerraformExpressionToTs)(scope, `${item}`, () => (0, terraformSchema_1.getDesiredType)(scope, path));
        case "number":
            return await (0, expressions_1.convertTerraformExpressionToTs)(scope, `${item}`, () => (0, terraformSchema_1.getDesiredType)(scope, path));
        case "object": {
            if (item === undefined || item === null) {
                return t.nullLiteral();
            }
            // For iterators and dynamic blocks we put the correct TS expression in the config ahead of time
            if (t.isNode(item) && t.isExpression(item)) {
                return item;
            }
            const attributeType = (0, terraformSchema_1.getTypeAtPath)(scope.providerSchema, path);
            function shouldRemoveArrayBasedOnType(attributeType) {
                if (!attributeType) {
                    return false; // The default assumption is we need the array
                }
                // maps and object don't need to be wrapped in an array
                if (Array.isArray(attributeType) &&
                    (attributeType[0] === "map" || attributeType[0] === "object")) {
                    return true;
                }
                // If it's a block type with max_items = 1 we don't need to wrap it in an array
                if (typeof attributeType === "object" &&
                    "max_items" in attributeType &&
                    attributeType.max_items === 1) {
                    return true;
                }
                return false;
            }
            const unwrappedItem = Array.isArray(item) &&
                (shouldRemoveArrayBasedOnType(attributeType) ||
                    path.endsWith("lifecycle") ||
                    path.endsWith("connection"))
                ? item[0]
                : item;
            if (Array.isArray(unwrappedItem)) {
                return t.arrayExpression(await Promise.all(unwrappedItem.map((i) => (0, exports.valueToTs)(scope, i, `${path}.[]`))));
            }
            return t.objectExpression((await Promise.all(Object.entries(unwrappedItem).map(async ([key, value]) => {
                if (value === undefined) {
                    return undefined;
                }
                if (key === "dynamic") {
                    const { for_each, ...others } = value;
                    const dynamicRef = Object.keys(others)[0];
                    return t.objectProperty(t.identifier(scope.withinOverrideExpression
                        ? dynamicRef
                        : (0, provider_generator_1.escapeAttributeName)((0, utils_1.camelCase)(dynamicRef))), t.arrayExpression());
                }
                const itemPath = `${path}.${key}`;
                const itemAttributeType = (0, terraformSchema_1.getTypeAtPath)(scope.providerSchema, itemPath);
                const typeMetadata = (0, terraformSchema_1.getTypeAtPath)(scope.providerSchema, itemPath);
                const isSingleItemBlock = typeMetadata &&
                    typeof typeMetadata === "object" &&
                    Object.prototype.hasOwnProperty.call(typeMetadata, "max_items")
                    ? typeMetadata.max_items === 1
                    : false;
                const shouldBeArray = typeof value === "object" &&
                    !Array.isArray(value) &&
                    !(t.isNode(value) && t.isExpression(value)) &&
                    !isSingleItemBlock &&
                    // Map type attributes must not be wrapped in arrays
                    !(0, terraformSchema_1.isMapAttribute)(itemAttributeType) &&
                    key !== "tags" &&
                    key !== "forEach" &&
                    key !== "lifecycle";
                const keepKeyName = !isModule &&
                    key !== "depends_on" &&
                    !path.includes("lifecycle") &&
                    (key === "for_each" ||
                        !typeMetadata ||
                        (0, terraformSchema_1.isMapAttribute)(attributeType)) &&
                    !(path.startsWith("var.") && path.includes("validation"));
                return t.objectProperty(t.stringLiteral(keepKeyName ? key : attributeNameToCdktfName(key)), shouldBeArray
                    ? t.arrayExpression([await (0, exports.valueToTs)(scope, value, itemPath)])
                    : await (0, exports.valueToTs)(scope, value, itemPath));
            }))).filter((expr) => expr !== undefined));
        }
    }
    throw new Error("Unsupported type " + item);
};
exports.valueToTs = valueToTs;
async function backendToExpression(scope, tf) {
    return (await Promise.all(Object.entries(tf || {}).map(async ([type, [config]]) => {
        const backendIdentifier = (0, utils_1.pascalCase)(`${type}Backend`);
        scope.importables.push({
            constructName: backendIdentifier,
            provider: "cdktf",
        });
        return t.expressionStatement(t.newExpression(t.identifier(backendIdentifier), [
            t.thisExpression(),
            t.objectExpression((await Promise.all(Object.entries(config).map(async ([property, value]) => t.objectProperty(t.identifier((0, utils_1.camelCase)(property)), await (0, exports.valueToTs)(scope, value, "path-for-backends-can-be-ignored"))))).reduce((carry, item) => [...carry, item], [])),
        ]));
    }))).reduce((carry, item) => [...carry, item], []);
}
exports.backendToExpression = backendToExpression;
function addOverrideExpression(variable, path, value, explanatoryComment) {
    const ast = t.expressionStatement(t.callExpression(t.memberExpression(t.identifier(variable), t.identifier("addOverride")), [t.stringLiteral(path), value]));
    if (explanatoryComment) {
        t.addComment(ast, "leading", explanatoryComment);
    }
    return ast;
}
function addOverrideLogicalIdExpression(variable, logicalId) {
    const ast = t.expressionStatement(t.callExpression(t.memberExpression(t.identifier(variable), t.identifier("overrideLogicalId")), [t.stringLiteral(logicalId)]));
    t.addComment(ast, "leading", "This allows the Terraform resource name to match the original name. You can remove the call if you don't need them to match.");
    return ast;
}
function getRemoteStateType(item) {
    const backendRecord = item.find((val) => val.backend);
    if (backendRecord) {
        const backend = backendRecord.backend;
        switch (backend) {
            case "remote":
                return "";
            case "etcdv3":
                return "_etcd_v3";
            default:
                return `_${backend}`;
        }
    }
    else {
        return "";
    }
}
function resourceType(provider, name, item) {
    switch (provider) {
        case "data.terraform":
            return `cdktf.data_terraform_${name.join("_")}${getRemoteStateType(item)}`;
        case "null":
            return `NullProvider.${name.join("_")}`;
        default:
            return `${provider}.${name.join("_")}`;
    }
}
function mapConfigPerResourceType(resource, item) {
    // Backends have a slightly different API
    if (resource.startsWith("cdktf.data_terraform_")) {
        return item.config;
    }
    return item;
}
const loopComment = `In most cases loops should be handled in the programming language context and
not inside of the Terraform context. If you are looping over something external, e.g. a variable or a file input
you should consider using a for loop. If you are looping over something only known to Terraform, e.g. a result of a data source
you need to keep this like it is.`;
async function resource(scope, type, key, id, item, graph) {
    const [provider, ...name] = type.split("_");
    const resource = resourceType(provider, name, item);
    if (!provider) {
        throw new Error(`Could not parse resource type '${type}'`);
    }
    let expressions = [];
    const varName = (0, variables_1.variableName)(scope, resource, key);
    const { for_each, count, provisioner, ...config } = item[0];
    const mappedConfig = mapConfigPerResourceType(resource, config);
    let forEachIteratorName;
    if (for_each) {
        forEachIteratorName = (0, variables_1.variableName)(scope, resource, `${key}_for_each_iterator`);
        const referenceAst = await (0, expressions_1.convertTerraformExpressionToTs)(scope, `"${for_each}"`, () => ["list", "dynamic"]);
        scope.importables.push({
            provider: "cdktf",
            constructName: "TerraformIterator",
        });
        const iterator = t.variableDeclaration("const", [
            t.variableDeclarator(t.identifier(forEachIteratorName), t.callExpression(t.memberExpression(t.identifier("TerraformIterator"), t.identifier("fromList")), [referenceAst])),
        ]);
        t.addComment(iterator, "leading", loopComment);
        expressions.push(iterator);
        mappedConfig.forEach = t.identifier(forEachIteratorName);
    }
    let countIteratorName;
    if (count) {
        countIteratorName = (0, variables_1.variableName)(scope, resource, `${key}_count`);
        const referenceAst = await (0, expressions_1.convertTerraformExpressionToTs)(scope, `"${count}"`, () => "number");
        scope.importables.push({
            provider: "cdktf",
            constructName: "TerraformCount",
        });
        const iterator = t.variableDeclaration("const", [
            t.variableDeclarator(t.identifier(countIteratorName), t.callExpression(t.memberExpression(t.identifier("TerraformCount"), t.identifier("of")), [referenceAst])),
        ]);
        t.addComment(iterator, "leading", loopComment);
        mappedConfig.count = t.identifier(countIteratorName);
        expressions.push(iterator);
    }
    const dynBlocks = (0, dynamic_blocks_1.extractDynamicBlocks)(mappedConfig);
    const nestedDynamicBlocks = dynBlocks.filter((block) => (0, dynamic_blocks_1.isNestedDynamicBlock)(dynBlocks, block));
    const dynamicBlocksUsingOverrides = dynBlocks.filter((block) => 
    // nested blocks need overrides
    nestedDynamicBlocks.includes(block) ||
        // blocks that contain nested blocks need them as well
        nestedDynamicBlocks.some((nestedBlock) => nestedBlock.path.startsWith(block.path)));
    // all others can be handled by the CDKTF runtime
    const dynamicBlocksUsingRuntime = dynBlocks.filter((block) => !dynamicBlocksUsingOverrides.includes(block));
    for (const [i, block] of dynamicBlocksUsingRuntime.entries()) {
        const dynamicBlockIteratorName = (0, variables_1.variableName)(scope, resource, `${key}_dynamic_iterator_${i}`);
        const referenceAst = await (0, expressions_1.convertTerraformExpressionToTs)(scope, `"${block.for_each}"`, () => ["list", "dynamic"]);
        scope.importables.push({
            provider: "cdktf",
            constructName: "TerraformIterator",
        });
        const iterator = t.variableDeclaration("const", [
            t.variableDeclarator(t.identifier(dynamicBlockIteratorName), t.callExpression(t.memberExpression(t.identifier("TerraformIterator"), t.identifier("fromList")), [referenceAst])),
        ]);
        t.addComment(iterator, "leading", loopComment);
        expressions.push(iterator);
        const dynamicCallExpression = t.callExpression(t.memberExpression(t.identifier(dynamicBlockIteratorName), t.identifier("dynamic")), [
            await (0, exports.valueToTs)({
                ...scope,
                scopedVariables: {
                    [block.scopedVar]: dynamicBlockIteratorName,
                },
            }, (0, partialCode_1.fillWithConfigAccessors)(scope, Array.isArray(block.content) ? block.content[0] : block.content, block.path.replace(block.scopedVar, "")), block.path.replace(block.scopedVar, ""), false),
        ]);
        const parts = block.path
            .replace(`dynamic.${block.scopedVar}`, "")
            .split(".")
            .filter((p) => p.length > 0);
        const parent = parts.reduce((acc, part) => {
            if (Array.isArray(acc) && !Number.isNaN(parseInt(part, 10))) {
                return acc[parseInt(part, 10)];
            }
            else {
                return acc[part];
            }
        }, mappedConfig);
        parent[block.scopedVar] = dynamicCallExpression;
        delete parent.dynamic;
    }
    const overrideReference = dynamicBlocksUsingOverrides.length
        ? {
            start: 0,
            end: 0,
            referencee: {
                id: `${type}.${key}`,
                full: `${type}.${key}`,
            },
        }
        : undefined;
    if (provisioner) {
        mappedConfig.provisioners = await Promise.all(Object.entries(provisioner).flatMap(([type, p]) => p.map((pp) => (0, exports.valueToTs)(scope, { type, ...pp }, "path-for-provisioners-can-be-ignored"))));
    }
    const importGraphId = `import.${resource.replace(".", "_")}.${key}`;
    const importDefinition = graph.hasNode(importGraphId)
        ? graph.getNodeAttribute(importGraphId, "value")
        : undefined;
    expressions = expressions.concat(await asExpression({ ...scope, forEachIteratorName, countIteratorName }, resource, key, mappedConfig, false, false, getReference(graph, id) || overrideReference, importDefinition));
    // Check for dynamic blocks
    expressions = expressions.concat(await Promise.all(dynamicBlocksUsingOverrides.map(async ({ path, for_each, content }) => {
        // We need to let the expression conversion know all available
        // dynamic block names, so we don't replace them. The "dynamic-block"
        // scoped variable indicates to the expression conversion to use the
        // key name instead of an iterator
        const scopedVariablesInPath = Object.fromEntries(path
            .substring(1) // The path starts with a dot that results in an empty split
            .split(".")
            .filter((p) => !["dynamic", "content"].includes(p) && isNaN(parseInt(p)))
            .map((p) => [p, "dynamic-block"]));
        return addOverrideExpression(varName, path.substring(1), // The path starts with a dot that we don't want
        await (0, exports.valueToTs)({
            ...scope,
            withinOverrideExpression: true,
            scopedVariables: scopedVariablesInPath,
        }, {
            for_each,
            content,
        }, "path-for-dynamic-blocks-can-be-ignored"), loopComment);
    })));
    return expressions;
}
exports.resource = resource;
async function asExpression(scope, type, name, config, isModuleImport, isProvider, reference, imported) {
    const { providers, ...otherOptions } = config;
    const constructId = (0, utils_1.uniqueId)(scope.constructs, name);
    const overrideId = !isProvider && constructId !== name;
    const completeObject = (0, partialCode_1.fillWithConfigAccessors)(scope, otherOptions, type);
    const expression = t.newExpression((0, variables_1.constructAst)(scope, type, isModuleImport), [
        t.thisExpression(),
        t.stringLiteral(constructId),
        await (0, exports.valueToTs)(scope, {
            ...completeObject,
            providers: providers && Object.keys(providers).length
                ? Object.entries(providers).map(([key, value]) => ({
                    moduleAlias: key,
                    provider: value,
                }))
                : undefined,
        }, `${type}`, isModuleImport),
    ]);
    const statements = [];
    const varName = reference
        ? (0, variables_1.referenceToVariableName)(scope, reference)
        : (0, variables_1.variableName)(scope, type, name);
    if (reference || overrideId || imported) {
        statements.push(t.variableDeclaration("const", [
            t.variableDeclarator(t.identifier(varName), expression),
        ]));
    }
    else {
        statements.push(t.expressionStatement(expression));
    }
    if (overrideId) {
        statements.push(addOverrideLogicalIdExpression(varName, name));
    }
    if (imported) {
        // Adds myVar.importFrom("my-arn")
        const importExpression = t.expressionStatement(t.callExpression(t.memberExpression(t.identifier(varName), t.identifier("importFrom")), [t.stringLiteral(imported.id)]));
        if (imported.provider) {
            t.addComment(importExpression, "leading", `This import was configured with a provider. CDKTF does support this, but the cdktf convert command does not yet. Please add the provider reference manually. See https://developer.hashicorp.com/terraform/cdktf/concepts/resources#importing-resources for more information.`);
        }
        statements.push(importExpression);
    }
    return statements;
}
async function output(scope, key, _id, item, _graph) {
    const [{ value, description, sensitive }] = item;
    return asExpression(scope, "cdktf.TerraformOutput", key, {
        value,
        description,
        sensitive,
    }, false, false, undefined, undefined);
}
exports.output = output;
async function variableTypeToAst(scope, type) {
    const addVariableTypeToImports = () => scope.importables.push({
        constructName: "VariableType",
        provider: "cdktf",
    });
    function parsedTypeToAst(type) {
        if (hcl2json_1.TFExpressionSyntaxTree.isScopeTraversalExpression(type)) {
            addVariableTypeToImports();
            switch (type.meta.value) {
                case "string":
                    return t.identifier("VariableType.STRING");
                case "number":
                    return t.identifier("VariableType.NUMBER");
                case "bool":
                    return t.identifier("VariableType.BOOL");
                case "any":
                default:
                    return t.identifier("VariableType.ANY");
            }
        }
        if (hcl2json_1.TFExpressionSyntaxTree.isFunctionCallExpression(type)) {
            addVariableTypeToImports();
            switch (type.meta.name) {
                case "list":
                case "set":
                case "map":
                case "tuple":
                case "object":
                    return t.callExpression(t.identifier(`VariableType.${type.meta.name}`), type.children.map((child) => parsedTypeToAst(child)));
            }
        }
        if (hcl2json_1.TFExpressionSyntaxTree.isObjectExpression(type)) {
            return t.objectExpression(Object.entries(type.meta.items).map(([key, value]) => t.objectProperty(t.stringLiteral(key), 
            // This does not deal with complex types nested within objects
            // If such a type is found it will result in an Any type
            // e.g. { foo: list(string) } will result in { foo: any }
            parsedTypeToAst({
                type: "scopeTraversal",
                meta: { value },
            }))));
        }
        addVariableTypeToImports();
        return t.identifier("VariableType.ANY");
    }
    return parsedTypeToAst(await (0, expressions_1.expressionAst)(type));
}
exports.variableTypeToAst = variableTypeToAst;
async function variable(scope, key, id, item, graph) {
    const [{ type, ...props }] = item;
    if (!getReference(graph, id)) {
        return [];
    }
    return asExpression(scope, id, key, { ...props, type: type ? await variableTypeToAst(scope, type) : undefined }, false, false, getReference(graph, id), undefined);
}
exports.variable = variable;
async function local(scope, key, id, item, graph) {
    utils_1.logger.debug(`Initializing local resource ${key} with id ${id}`);
    if (!getReference(graph, id)) {
        utils_1.logger.debug(`No reference found for ${key}`);
        return [];
    }
    return [
        t.variableDeclaration("const", [
            t.variableDeclarator(t.identifier((0, variables_1.variableName)(scope, "local", key)), await (0, exports.valueToTs)(scope, item, "path-for-local-blocks-can-be-ignored")),
        ]),
    ];
}
exports.local = local;
async function modules(scope, key, id, item, graph) {
    const [{ source, version, ...props }] = item;
    const moduleConstraint = new provider_generator_1.TerraformModuleConstraint(source);
    return asExpression(scope, moduleConstraint.className, key, props, true, false, getReference(graph, id), undefined);
}
exports.modules = modules;
async function imports(scope, _id, item, graph) {
    // Move from ${aws_instance.example} to aws_instance.example
    const target = item.to.startsWith("${") && item.to.endsWith("}")
        ? item.to.substring(2, item.to.length - 1)
        : item.to;
    // Check if the import goes into a module
    if (target.startsWith("module.")) {
        return [
            t.addComment(t.emptyStatement(), "leading", `CDKTF does not support imports into modules yet, please remove the import block importing ${item.id} into ${target} from your configuration`),
        ];
    }
    // We now know that the import goes into a resource, e.g. aws_instance.example
    const [resourceTypeIdentifier, resourceName] = target.split(".");
    if (resourceName.includes("[")) {
        return [
            t.addComment(t.emptyStatement(), "leading", `CDKTF does not support imports into resources with count or for_each yet, please remove the import block importing ${item.id} into ${target} from your configuration`),
        ];
    }
    // Check if we have a existing resource config with the given name
    if (graph.hasNode(target)) {
        // We will handle this case in the resource function
        // so we can skip over it
        return [];
    }
    const [provider, ...resourceTypeNameParts] = resourceTypeIdentifier.split("_");
    const constructId = (0, utils_1.uniqueId)(scope.constructs, (0, utils_1.camelCase)(resourceName));
    const constructClass = (0, variables_1.constructAst)(scope, `${provider}.${resourceTypeNameParts.join("_")}`, false);
    return [
        t.expressionStatement(t.callExpression(t.memberExpression(constructClass, t.identifier("generateConfigForImport")), [
            t.thisExpression(),
            t.stringLiteral(constructId),
            t.stringLiteral(item.id),
        ])),
    ];
}
exports.imports = imports;
async function provider(scope, key, id, item, graph) {
    const { version, ...props } = item;
    const importKey = key === "null" ? "NullProvider" : key;
    return asExpression(scope, `${importKey}.${(0, utils_1.pascalCase)(key)}Provider`, key, props, false, true, getReference(graph, id), undefined);
}
exports.provider = provider;
exports.cdktfImport = (0, template_1.default)(`import * as cdktf from "cdktf"`)();
exports.constructsImport = (0, template_1.default)(`import * as constructs from "constructs"`)();
const providerImports = (providers) => providers.map((providerName) => {
    const parts = providerName.split("/");
    const name = parts.length > 1 ? parts[1] : parts[0];
    const importName = name === "null" ? "NullProvider" : name;
    return (0, template_1.default)(`import * as ${importName} from "./.gen/providers/${name.replace("./", "")}"`)();
});
exports.providerImports = providerImports;
const moduleImports = (modules) => {
    const uniqueModules = new Set();
    Object.values(modules || {}).map(([module]) => uniqueModules.add(module.source));
    const imports = [];
    uniqueModules.forEach((m) => {
        const moduleConstraint = new provider_generator_1.TerraformModuleConstraint(m);
        imports.push(template_1.default.ast(`import * as ${moduleConstraint.className} from "./.gen/modules/${moduleConstraint.fileName}"`));
    });
    return imports;
};
exports.moduleImports = moduleImports;
async function gen(statements) {
    utils_1.logger.debug(`Generating code for ${JSON.stringify(statements, null, 2)}`);
    const code = prettier_1.default.format((0, generator_1.default)(t.program(statements)).code, {
        parser: "babel",
    });
    utils_1.logger.debug(`Generated code:\n${code}`);
    return code;
}
exports.gen = gen;
function addImportForCodeContainer(scope, codeContainer) {
    switch (codeContainer) {
        case "constructs.Construct":
            scope.importables.push({
                provider: "constructs",
                constructName: "Construct",
            });
            break;
        case "cdktf.TerraformStack":
            scope.importables.push({
                provider: "cdktf",
                constructName: "TerraformStack",
            });
            break;
        default:
            throw commons_1.Errors.Internal("Unsupported code container: " + codeContainer);
    }
}
exports.addImportForCodeContainer = addImportForCodeContainer;
function wrapCodeInConstructor(codeContainer, code, className, configTypeName) {
    let baseContainerClass;
    switch (codeContainer) {
        case "constructs.Construct":
            baseContainerClass = t.identifier("Construct");
            break;
        case "cdktf.TerraformStack":
            baseContainerClass = t.identifier("TerraformStack");
            break;
        default:
            throw commons_1.Errors.Internal("Unsupported code container: " + codeContainer);
    }
    if (configTypeName) {
        return template_1.default.statement(`
  class %%className%% extends %%base%% {
    constructor(scope: Construct, name: string, config: ${configTypeName}) {
      super(scope, name);
      %%code%%
    }
  }
`, { syntacticPlaceholders: true, plugins: ["typescript"] })({
            code,
            base: baseContainerClass,
            className: t.identifier(className),
        });
    }
    return template_1.default.statement(`
  class %%className%% extends %%base%% {
    constructor(scope: Construct, name: string) {
      super(scope, name);
      %%code%%
    }
  }
`, { syntacticPlaceholders: true, plugins: ["typescript"] })({
        code,
        base: baseContainerClass,
        className: t.identifier(className),
    });
}
exports.wrapCodeInConstructor = wrapCodeInConstructor;
const providerConstructImports = (importable) => {
    let provider = importable[0].provider;
    let namespace = importable[0].namespace;
    const names = importable.map((i) => i.constructName);
    if (provider === "cdktf" || provider === "constructs") {
        return (0, template_1.default)(`import { ${names.join(", ")} } from "${provider}"`)();
    }
    if (namespace) {
        namespace = (0, util_1.snakeCase)(namespace).replace(/_/g, "-");
    }
    // Special cases to undo provider names that we override
    if (provider === "NullProvider") {
        provider = "null";
    }
    return (0, template_1.default)(`import { ${names.join(", ")} } from "./.gen/providers/${provider}/${namespace}"`)();
};
exports.providerConstructImports = providerConstructImports;
function buildImports(importables) {
    const groupedImportables = importables.reduce((acc, importable) => {
        const ns = importable.namespace || "";
        // Doing some hacky ordering of the imports to make them look a bit nicer
        const prefix = importable.provider === "constructs"
            ? "1"
            : importable.provider === "cdktf"
                ? "2"
                : "3";
        const groupName = `${prefix}.${importable.provider}.${ns}`;
        const fullName = `${importable.provider}.${ns}.${importable.constructName}`;
        if (acc[groupName]) {
            const existsAlready = acc[groupName].some((importable) => `${importable.provider}.${ns}.${importable.constructName}` ===
                fullName);
            if (existsAlready) {
                return acc;
            }
            acc[groupName].push(importable);
            acc[groupName].sort();
        }
        else {
            acc[groupName] = [importable];
        }
        return acc;
    }, {});
    let commentAdded = false;
    const constructImports = Object.keys(groupedImportables)
        .sort()
        .map((groupName) => {
        const importStatement = (0, exports.providerConstructImports)(groupedImportables[groupName]);
        if (groupName.startsWith("3.") && !commentAdded) {
            commentAdded = true;
            t.addComment(importStatement, "leading", `\n* Provider bindings are generated by running \`cdktf get\`.
* See https://cdk.tf/provider-generation for more details.\n`);
        }
        return importStatement;
    });
    return constructImports;
}
exports.buildImports = buildImports;
function generateConfigType(name, config) {
    return t.tsInterfaceDeclaration(t.identifier(name), undefined, undefined, t.tsInterfaceBody(Object.entries(config).map(([key, _value]) => t.tsPropertySignature(t.identifier(key), t.tSTypeAnnotation(t.tsAnyKeyword())))));
}
exports.generateConfigType = generateConfigType;
//# sourceMappingURL=data:application/json;base64,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