import * as t from "@babel/types";
import { DirectedGraph } from "graphology";
import { TerraformResourceBlock, ProgramScope, ResourceScope, ImportableConstruct, AttributePath } from "./types";
import { Resource, TerraformConfig, Module, Provider, Variable, Output, Import } from "./schema";
export declare function attributeNameToCdktfName(name: string): string;
export declare const valueToTs: (scope: ResourceScope, item: TerraformResourceBlock, path: string, isModule?: boolean) => Promise<t.Expression>;
export declare function backendToExpression(scope: ProgramScope, tf: TerraformConfig["backend"]): Promise<t.Statement[]>;
export declare function resource(scope: ProgramScope, type: string, key: string, id: string, item: Resource, graph: DirectedGraph): Promise<t.Statement[]>;
export declare function output(scope: ProgramScope, key: string, _id: string, item: Output, _graph: DirectedGraph): Promise<(t.ExpressionStatement | t.VariableDeclaration)[]>;
export declare function variableTypeToAst(scope: ProgramScope, type: string): Promise<t.Expression>;
export declare function variable(scope: ProgramScope, key: string, id: string, item: Variable, graph: DirectedGraph): Promise<(t.ExpressionStatement | t.VariableDeclaration)[]>;
export declare function local(scope: ProgramScope, key: string, id: string, item: TerraformResourceBlock, graph: DirectedGraph): Promise<t.VariableDeclaration[]>;
export declare function modules(scope: ProgramScope, key: string, id: string, item: Module, graph: DirectedGraph): Promise<(t.ExpressionStatement | t.VariableDeclaration)[]>;
export declare function imports(scope: ProgramScope, _id: string, item: Import, graph: DirectedGraph): Promise<t.ExpressionStatement[] | t.EmptyStatement[]>;
export declare function provider(scope: ProgramScope, key: string, id: string, item: Provider[0], graph: DirectedGraph): Promise<(t.ExpressionStatement | t.VariableDeclaration)[]>;
export declare const cdktfImport: t.Statement;
export declare const constructsImport: t.Statement;
export declare const providerImports: (providers: string[]) => t.Statement[];
export declare const moduleImports: (modules: Record<string, Module> | undefined) => t.Statement[];
export declare function gen(statements: t.Statement[]): Promise<string>;
export declare function addImportForCodeContainer(scope: ProgramScope, codeContainer: string): void;
export declare function wrapCodeInConstructor(codeContainer: string, code: t.Statement[], className: string, configTypeName?: string): t.Statement;
export declare const providerConstructImports: (importable: ImportableConstruct[]) => t.Statement;
export declare function buildImports(importables: ImportableConstruct[]): t.Statement[];
export declare function generateConfigType(name: string, config: Record<string, AttributePath>): t.Statement;
//# sourceMappingURL=generation.d.ts.map