"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.tsFunctionsMap = exports.functionsMap = void 0;
const functions_generated_1 = require("./functions.generated");
exports.functionsMap = {
    ...functions_generated_1.functionsMapGenerated,
    bcrypt: {
        name: "bcrypt", // this one is not variadic anymore after we mapped it
        returnType: "string",
        parameters: [{ type: "string" }, { type: "number", optional: true }],
    },
    join: {
        name: "join",
        returnType: "string",
        parameters: [{ type: "string" }, { type: ["list", "string"] }],
        /**
         * Terraform supports join(separator, listA, listB)
         * wheras CDKTF only supports join(separator, list) (to make it simpler to use as JSII does not support variadic parameters)
         * and we'd need to convert this to join(separator, concat(listA, listB)) if multiple variadic args are passed
         */
        transformer: (fc) => {
            if (fc.children.length <= 2) {
                return fc; // just one child -> nothing to do
            }
            const concatFunction = {
                type: "function",
                meta: {
                    name: "concat",
                    expandedFinalArgument: fc.meta.expandedFinalArgument,
                    nameRange: {},
                    openParenRange: {},
                    closeParenRange: {},
                    argsRanges: [],
                },
                children: fc.children.slice(1),
            };
            return {
                type: "function",
                meta: {
                    name: "join",
                },
                children: [
                    fc.children[0], // the first parameter is the separator, so keep it as is
                    concatFunction,
                ],
            };
        },
    },
    range: {
        name: "range",
        returnType: ["list", "string"], // TODO: Fn.range() currently returns string[] but should return number[] (according to functions.json)
        parameters: [
            { type: "number" },
            { type: "number" },
            { type: "number", optional: true },
        ],
    },
    lookup: {
        name: "lookup",
        returnType: "dynamic",
        parameters: [{ type: "dynamic" }, { type: "string" }, { type: "dynamic" }],
    },
};
exports.tsFunctionsMap = Object.entries(exports.functionsMap).reduce((acc, [name, fnInfo]) => {
    // Swap the names around
    acc[fnInfo.name] = { ...fnInfo, name: name };
    return acc;
}, {});
//# sourceMappingURL=data:application/json;base64,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