/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { AttributeType } from "@cdktf/commons";
type FunctionCall = any;
type FunctionMeta = {
    name: string;
    returnType: AttributeType;
    parameters: {
        type: AttributeType;
        optional?: boolean;
        variadic?: boolean;
    }[];
    /**
     * Allows transforming the function call before it is handled. This is currently used to handle
     * different APIs between TF supporting join(sep, listA, listB) and CDKTF only supporting join(sep, list)
     * (as the alternative due to JSIIs lack of support for variadic parametes would be join(sep, lists) which
     *  would have a worse UX as most often just a single list is passed)
     * In the case of join() the transformer will convert the function call to join(sep, concat(listA, listB))
     * before handling it
     *
     * Caution: Beware of infinite recursion if the returned function call is to the same function that has this
     * transformer. Return the same instance of the passed functionCall to break out of that recursion.
     */
    transformer?: (functionCall: FunctionCall) => FunctionCall;
};
export declare const functionsMap: Record<string, FunctionMeta>;
export declare const tsFunctionsMap: Record<string, FunctionMeta>;
export {};
//# sourceMappingURL=functions.d.ts.map