"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dynamicVariableToAst = exports.extractIteratorVariablesFromExpression = exports.convertTerraformExpressionToTs = exports.expressionAst = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const t = __importStar(require("@babel/types"));
const template_1 = __importDefault(require("@babel/template"));
const utils_1 = require("./utils");
const hcl2json_1 = require("@cdktf/hcl2json");
const hcl2json_2 = require("@cdktf/hcl2json");
const functions_1 = require("./function-bindings/functions");
const coerceType_1 = require("./coerceType");
const terraformSchema_1 = require("./terraformSchema");
const references_1 = require("./references");
const variables_1 = require("./variables");
const syntax_tree_1 = require("@cdktf/hcl2json/lib/syntax-tree");
const tfBinaryOperatorsToCdktf = {
    logicalOr: "or",
    logicalAnd: "and",
    greaterThan: "gt",
    greaterThanOrEqual: "gte",
    lessThan: "lt",
    lessThanOrEqual: "lte",
    equal: "eq",
    notEqual: "neq",
    add: "add",
    subtract: "sub",
    multiply: "mul",
    divide: "div",
    modulo: "mod",
};
const tfUnaryOperatorsToCdktf = {
    logicalNot: "not",
    negate: "negate",
};
function traversalPartsToString(traversals, asSuffix = false) {
    let seed = "";
    if (asSuffix && hcl2json_2.TFExpressionSyntaxTree.isNameTraversalPart(traversals[0])) {
        seed = ".";
    }
    return traversals.reduce((acc, part) => {
        if (part.type === "nameTraversal") {
            if (acc === seed) {
                return `${acc}${part.segment}`;
            }
            return `${acc}.${part.segment}`;
        }
        return `${acc}[${part.segment}]`;
    }, seed);
}
function canUseFqn(expression) {
    if (!hcl2json_2.TFExpressionSyntaxTree.isScopeTraversalExpression(expression)) {
        return false;
    }
    const rootSegment = expression.meta.traversal[0].segment;
    return !["var", "local"].includes(rootSegment);
}
function traversalToVariableName(scope, node) {
    if (!hcl2json_2.TFExpressionSyntaxTree.isScopeTraversalExpression(node)) {
        utils_1.logger.error(`Unexpected expression type ${node.type} with value ${node.meta.value} passed to convert to a variable. 
        ${utils_1.leaveCommentText}`);
        return "";
    }
    const segments = node.meta.traversal;
    if (segments.length === 1) {
        return node.meta.fullAccessor;
    }
    const rootSegment = segments[0].segment;
    const resource = rootSegment === "data"
        ? `${segments[0].segment}.${segments[1].segment}`
        : rootSegment;
    const name = rootSegment === "data" ? segments[2].segment : segments[1].segment;
    return (0, variables_1.variableName)(scope, resource, name);
}
function expressionForSerialStringConcatenation(scope, nodes) {
    const reducedNodes = nodes.reduce((acc, node) => {
        const prev = acc[acc.length - 1];
        if (!prev)
            return [node];
        if (t.isStringLiteral(prev) && t.isStringLiteral(node)) {
            acc.pop();
            acc.push(t.stringLiteral(prev.value + node.value));
            return acc;
        }
        acc.push(node);
        return acc;
    }, []);
    return reducedNodes.reduce((acc, node) => {
        if (!acc) {
            return node;
        }
        // wrap access to dynamic blocks in Token.asString() as they return a Lazy
        // for .key and .value which can't be concatenated in languages like Python
        // because JSII currently has no support for the toString() method in
        // languages other than TypeScript: https://github.com/aws/jsii/issues/380
        // example: dynamic_iterator0.key / dynamic_iterator0.value
        if (t.isMemberExpression(node) &&
            t.isIdentifier(node.object) &&
            Object.values(scope.scopedVariables || {}).includes(node.object.name) &&
            t.isIdentifier(node.property) &&
            ["key", "value"].includes(node.property.name)) {
            node = (0, coerceType_1.coerceType)(scope, node, "dynamic", "string");
        }
        return t.binaryExpression("+", acc, node);
    });
}
function getTfResourcePathFromNode(node) {
    const segments = node.meta.traversal;
    let resource = segments[0].segment;
    let result = [];
    let attributes = [];
    if (segments[0].segment === "data") {
        result.push(segments[0].segment);
        resource = segments[1].segment;
        attributes = segments.slice(3); // we want to skip the variable name
    }
    else {
        attributes = segments.slice(2); // we want to skip the variable name
    }
    const [provider, ...resourceNameFragments] = resource.split("_");
    // Hack: This happens in the case of `external` provider
    // where the data source does not have a provider name prefix
    if (resourceNameFragments.length === 0) {
        resourceNameFragments.push(provider);
    }
    result.push(provider);
    result.push(resourceNameFragments.join("_"));
    result = [
        ...result,
        ...attributes.map((seg) => {
            if (hcl2json_2.TFExpressionSyntaxTree.isIndexTraversalPart(seg)) {
                return `[${seg.segment}]`;
            }
            return seg.segment;
        }),
    ];
    return result.join(".");
}
function convertLiteralValueExpressionToTs(_scope, node) {
    const literalType = node.meta.type;
    if (literalType === "number") {
        return t.numericLiteral(Number(node.meta.value));
    }
    if (literalType === "bool") {
        return t.booleanLiteral(node.meta.value === "true" ? true : false);
    }
    return t.stringLiteral(node.meta.value);
}
function convertScopeTraversalExpressionToTs(scope, node) {
    var _a;
    const hasReference = (0, references_1.containsReference)(node);
    const segments = node.meta.traversal;
    if (segments[0].segment === "each" && scope.forEachIteratorName) {
        return dynamicVariableToAst(scope, node, scope.forEachIteratorName);
    }
    if (segments[0].segment === "count" && scope.countIteratorName) {
        return dynamicVariableToAst(scope, node, scope.countIteratorName, "count");
    }
    if (segments[0].segment === "self") {
        scope.importables.push({
            constructName: "TerraformSelf",
            provider: "cdktf",
        });
        return t.callExpression(t.memberExpression(t.identifier("TerraformSelf"), t.identifier("getAny")), [t.stringLiteral(traversalPartsToString(segments.slice(1)))]);
    }
    // setting.value, setting.value[1].id
    const dynamicBlock = (_a = scope.scopedVariables) === null || _a === void 0 ? void 0 : _a[segments[0].segment];
    if (dynamicBlock) {
        if (dynamicBlock === "dynamic-block") {
            return dynamicVariableToAst(scope, node, dynamicBlock, traversalPartsToString(segments));
        }
        return dynamicVariableToAst(scope, node, dynamicBlock, segments[0].segment);
    }
    // This may be a variable reference that we don't understand yet, so we wrap it in a template string
    // for Terraform to handle
    let varIdentifier = t.stringLiteral(`\${${node.meta.fullAccessor}}`);
    if (hasReference) {
        varIdentifier = t.identifier((0, utils_1.camelCase)(traversalToVariableName(scope, node)));
    }
    if (["var", "local"].includes(segments[0].segment)) {
        const variableAccessor = segments[0].segment === "var"
            ? t.memberExpression(varIdentifier, t.identifier("value"))
            : varIdentifier;
        if (segments.length > 2) {
            scope.importables.push({
                constructName: "Fn",
                provider: "cdktf",
            });
            const callee = t.memberExpression(t.identifier("Fn"), t.identifier("lookupNested"));
            return t.callExpression(callee, [
                variableAccessor,
                t.arrayExpression(segments.slice(2).map((s) => t.stringLiteral(s.segment))),
            ]);
        }
        return variableAccessor;
    }
    if (!hasReference || scope.withinOverrideExpression) {
        return varIdentifier;
    }
    const rootSegment = segments[0].segment;
    const attributeIndex = rootSegment === "data" ? 3 : 2;
    const attributeSegments = segments.slice(attributeIndex);
    const numericAccessorIndex = attributeSegments.findIndex((seg) => hcl2json_2.TFExpressionSyntaxTree.isIndexTraversalPart(seg));
    let minAccessorIndex = numericAccessorIndex;
    let mapAccessorIndex = -1;
    if (numericAccessorIndex === -1) {
        // only do this if we have to, if we already have a
        // numeric accessor, we don't have to do this additional work
        const resourcePath = getTfResourcePathFromNode(node);
        let usingSubPathType = false;
        let parts = resourcePath.split(".").filter((p) => p !== "");
        const minParts = attributeIndex; // we need to stop before data.aws.resource_name or aws.resource_name
        const originalParts = parts.length;
        let hasMapAccessor = false;
        while (parts.length >= minParts) {
            const type = (0, terraformSchema_1.getTypeAtPath)(scope.providerSchema, parts.join("."));
            if (type !== null) {
                if (Array.isArray(type) && type[0] === "map" && usingSubPathType) {
                    hasMapAccessor = true;
                    break;
                }
            }
            parts.pop();
            usingSubPathType = true;
        }
        if (hasMapAccessor) {
            mapAccessorIndex = originalParts - parts.length - 1;
            minAccessorIndex = mapAccessorIndex;
        }
    }
    const needsPropertyAccess = minAccessorIndex >= 0;
    const refSegments = needsPropertyAccess
        ? attributeSegments.slice(0, minAccessorIndex)
        : attributeSegments;
    const nonRefSegments = needsPropertyAccess
        ? attributeSegments.slice(minAccessorIndex)
        : [];
    const ref = refSegments.reduce((acc, seg, index) => t.memberExpression(acc, t.identifier(index === 0 && rootSegment === "module"
        ? (0, utils_1.camelCase)(seg.segment + "Output")
        : (0, utils_1.camelCase)(seg.segment))), varIdentifier);
    if (nonRefSegments.length === 0) {
        return ref;
    }
    scope.importables.push({
        constructName: "Fn",
        provider: "cdktf",
    });
    const callee = t.memberExpression(t.identifier("Fn"), t.identifier("lookupNested"));
    return t.callExpression(callee, [
        ref,
        t.arrayExpression(nonRefSegments.map((s) => t.stringLiteral(s.segment))),
    ]);
}
function convertUnaryOpExpressionToTs(scope, node) {
    const operand = convertTFExpressionAstToTs(scope, hcl2json_2.TFExpressionSyntaxTree.getChildWithValue(node, node.meta.valueExpression));
    let fnName = node.meta.operator;
    if (tfUnaryOperatorsToCdktf[fnName]) {
        fnName = tfUnaryOperatorsToCdktf[fnName];
    }
    else {
        throw new Error(`Cannot convert unknown operator ${node.meta.operator}`);
    }
    scope.importables.push({
        constructName: "Op",
        provider: "cdktf",
    });
    const fn = t.memberExpression(t.identifier("Op"), t.identifier(fnName));
    return t.callExpression(fn, [operand]);
}
function convertBinaryOpExpressionToTs(scope, node) {
    const left = convertTFExpressionAstToTs(scope, hcl2json_2.TFExpressionSyntaxTree.getChildWithValue(node, node.meta.lhsExpression));
    const right = convertTFExpressionAstToTs(scope, hcl2json_2.TFExpressionSyntaxTree.getChildWithValue(node, node.meta.rhsExpression));
    let fnName = node.meta.operator;
    if (tfBinaryOperatorsToCdktf[fnName]) {
        fnName = tfBinaryOperatorsToCdktf[fnName];
    }
    else {
        throw new Error(`Cannot convert unknown operator ${node.meta.operator}`);
    }
    scope.importables.push({
        constructName: "Op",
        provider: "cdktf",
    });
    const fn = t.memberExpression(t.identifier("Op"), t.identifier(fnName));
    return t.callExpression(fn, [left, right]);
}
function convertTemplateExpressionToTs(scope, node) {
    const parts = node.children.map((child) => ({
        node: child,
        expr: convertTFExpressionAstToTs(scope, child),
    }));
    const lastPart = parts[parts.length - 1];
    if (t.isStringLiteral(lastPart.expr) && lastPart.expr.value === "\n") {
        // This is a bit of a hack, but the trailing newline we add due to
        // heredocs looks ugly and unnecessary in the generated code, so we
        // try to remove it
        parts.pop();
    }
    if (parts.length === 0) {
        return t.stringLiteral(node.meta.value);
    }
    if (parts.length === 1) {
        return parts[0].expr;
    }
    let isScopedTraversal = false;
    let expressions = [];
    for (const { node, expr } of parts) {
        if (hcl2json_2.TFExpressionSyntaxTree.isScopeTraversalExpression(node) &&
            !t.isStringLiteral(expr) &&
            !t.isCallExpression(expr)) {
            expressions.push(t.stringLiteral("${"));
            isScopedTraversal = true;
        }
        else if (
        // we should ideally be doing type coercion more
        // carefully here, because it may not always be needed
        t.isCallExpression(expr)) {
            scope.importables.push({
                constructName: "Token",
                provider: "cdktf",
            });
            expressions.push(template_1.default.expression(`Token.asString(%%expr%%)`)({
                expr,
            }));
            continue;
        }
        else {
            if (isScopedTraversal) {
                expressions.push(t.stringLiteral("}"));
                isScopedTraversal = false;
            }
        }
        expressions.push(expr);
    }
    if (isScopedTraversal) {
        expressions.push(t.stringLiteral("}"));
    }
    return expressionForSerialStringConcatenation(scope, expressions);
}
function convertObjectExpressionToTs(scope, node) {
    return t.objectExpression(Object.entries(node.meta.items)
        .map(([key, value]) => {
        const valueChild = (0, syntax_tree_1.getChildWithValue)(node, value);
        if (!valueChild) {
            utils_1.logger.error(`Unable to value for object key '${key}': ${value}`);
            return null;
        }
        return t.objectProperty(t.identifier(key), convertTFExpressionAstToTs(scope, valueChild));
    })
        .filter((s) => s !== null));
}
function convertFunctionCallExpressionToTs(scope, node) {
    const functionName = node.meta.name;
    const mapping = functions_1.functionsMap[functionName];
    if (!mapping) {
        utils_1.logger.error(`Unknown function ${functionName} encountered. ${utils_1.leaveCommentText}`);
        const argumentExpressions = node.children.map((child) => convertTFExpressionAstToTs(scope, child));
        return t.callExpression(t.identifier(functionName), argumentExpressions);
    }
    let transformedNode = mapping.transformer
        ? mapping.transformer(node)
        : node;
    const argumentExpressions = transformedNode.children.map((child) => convertTFExpressionAstToTs(scope, child));
    scope.importables.push({
        constructName: "Fn",
        provider: "cdktf",
    });
    const callee = t.memberExpression(t.identifier("Fn"), t.identifier(mapping.name));
    if (mapping.parameters.length > 0 &&
        mapping.parameters[mapping.parameters.length - 1].variadic) {
        const lastParameterType = mapping.parameters[mapping.parameters.length - 1].type;
        const nonVariadicArguments = argumentExpressions.slice(0, mapping.parameters.length - 1);
        const fnCallArguments = [
            ...nonVariadicArguments.map((argExpr, index) => (0, coerceType_1.coerceType)(scope, argExpr, (0, coerceType_1.findExpressionType)(scope, argExpr), mapping.parameters[index].type)),
            t.arrayExpression(argumentExpressions
                .slice(mapping.parameters.length - 1)
                .map((argExpr) => (0, coerceType_1.coerceType)(scope, argExpr, (0, coerceType_1.findExpressionType)(scope, argExpr), lastParameterType))),
        ];
        return t.callExpression(callee, fnCallArguments);
    }
    return t.callExpression(callee, argumentExpressions.map((argExpr, index) => (0, coerceType_1.coerceType)(scope, argExpr, (0, coerceType_1.findExpressionType)(scope, argExpr), mapping.parameters[index].type)));
}
function convertIndexExpressionToTs(scope, node) {
    const collectionExpressionChild = hcl2json_2.TFExpressionSyntaxTree.getChildWithValue(node, node.meta.collectionExpression);
    const keyExpressionChild = hcl2json_2.TFExpressionSyntaxTree.getChildWithValue(node, node.meta.keyExpression);
    const collectionExpression = convertTFExpressionAstToTs(scope, collectionExpressionChild);
    const keyExpression = convertTFExpressionAstToTs(scope, keyExpressionChild);
    scope.importables.push({
        constructName: "Fn",
        provider: "cdktf",
    });
    const callee = t.memberExpression(t.identifier("Fn"), t.identifier("lookupNested"));
    return t.callExpression(callee, [
        collectionExpression,
        t.arrayExpression([keyExpression]),
    ]);
}
function convertSplatExpressionToTs(scope, node) {
    const sourceExpressionChild = hcl2json_2.TFExpressionSyntaxTree.getChildWithValue(node, node.meta.sourceExpression);
    let sourceExpression = convertTFExpressionAstToTs(scope, sourceExpressionChild);
    // We don't convert the relative expression because everything after the splat is going to be
    // a string
    let relativeExpression = node.meta.eachExpression.startsWith(node.meta.anonSymbolExpression)
        ? node.meta.eachExpression.slice(node.meta.anonSymbolExpression.length)
        : node.meta.eachExpression;
    const segments = relativeExpression.split(/\.|\[|\]/).filter((s) => s);
    scope.importables.push({
        constructName: "Fn",
        provider: "cdktf",
    });
    const callee = t.memberExpression(t.identifier("Fn"), t.identifier("lookupNested"));
    return t.callExpression(callee, [
        sourceExpression,
        t.arrayExpression([
            // we don't need to use the anonSymbolExpression here because
            // it only changes between .* and [*] which we don't care about
            t.stringLiteral("*"),
            ...segments.map(t.stringLiteral),
        ]),
    ]);
}
function convertConditionalExpressionToTs(scope, node) {
    const conditionChild = hcl2json_2.TFExpressionSyntaxTree.getChildWithValue(node, node.meta.conditionExpression);
    let condition = convertTFExpressionAstToTs(scope, conditionChild);
    if (t.isIdentifier(condition) && canUseFqn(conditionChild)) {
        // We have a resource or data source here, which we would need to
        // reference using fqn
        condition = t.memberExpression(condition, t.identifier("fqn"));
    }
    const trueExpression = convertTFExpressionAstToTs(scope, hcl2json_2.TFExpressionSyntaxTree.getChildWithValue(node, node.meta.trueExpression));
    const falseExpression = convertTFExpressionAstToTs(scope, hcl2json_2.TFExpressionSyntaxTree.getChildWithValue(node, node.meta.falseExpression));
    scope.importables.push({
        constructName: "conditional",
        provider: "cdktf",
    });
    return t.callExpression(t.identifier("conditional"), [
        condition,
        trueExpression,
        falseExpression,
    ]);
}
function convertTupleExpressionToTs(scope, node) {
    const expressions = node.children.map((child) => convertTFExpressionAstToTs(scope, child));
    return t.arrayExpression(expressions);
}
function convertRelativeTraversalExpressionToTs(scope, node) {
    const segments = node.meta.traversal;
    // The left hand side / source of a relative traversal is not a proper
    // object / resource / data thing that is being referenced
    const source = convertTFExpressionAstToTs(scope, hcl2json_2.TFExpressionSyntaxTree.getChildWithValue(node, node.meta.sourceExpression));
    scope.importables.push({
        constructName: "Fn",
        provider: "cdktf",
    });
    const callee = t.memberExpression(t.identifier("Fn"), t.identifier("lookupNested"));
    return t.callExpression(callee, [
        source,
        t.arrayExpression(segments.map((s) => t.stringLiteral(s.segment))),
    ]);
}
function convertForExpressionToTs(scope, node) {
    const collectionChild = hcl2json_2.TFExpressionSyntaxTree.getChildWithValue(node, node.meta.collectionExpression);
    let collectionExpression = convertTFExpressionAstToTs(scope, collectionChild);
    if (t.isIdentifier(collectionExpression) && canUseFqn(collectionChild)) {
        // We have a resource or data source here, which we would need to
        // reference using fqn
        collectionExpression = t.memberExpression(collectionExpression, t.identifier("fqn"));
    }
    const collectionRequiresWrapping = !t.isStringLiteral(collectionExpression);
    const expressions = [];
    const conditionBody = node.meta.keyVar
        ? `${node.meta.keyVar}, ${node.meta.valVar}`
        : node.meta.valVar;
    const openBrace = node.meta.openRangeValue;
    const closeBrace = node.meta.closeRangeValue;
    const grouped = node.meta.groupedValue ? "..." : "";
    const valueExpression = `${node.meta.valueExpression}${grouped}`;
    const prefix = `\${${openBrace} for ${conditionBody} in `;
    const keyValue = node.meta.keyExpression
        ? ` : ${node.meta.keyExpression} => ${valueExpression}`
        : ` : ${valueExpression}`;
    const conditional = node.meta.conditionalExpression;
    const suffix = `${keyValue}${conditional ? ` if ${conditional}` : ""}${closeBrace}}`;
    expressions.push(t.stringLiteral(prefix));
    if (collectionRequiresWrapping) {
        expressions.push(t.stringLiteral("${"));
    }
    expressions.push(collectionExpression);
    if (collectionRequiresWrapping) {
        expressions.push(t.stringLiteral("}"));
    }
    expressions.push(t.stringLiteral(suffix));
    return expressionForSerialStringConcatenation(scope, expressions);
}
function convertTFExpressionAstToTs(scope, node) {
    if (hcl2json_2.TFExpressionSyntaxTree.isLiteralValueExpression(node)) {
        return convertLiteralValueExpressionToTs(scope, node);
    }
    if (hcl2json_2.TFExpressionSyntaxTree.isScopeTraversalExpression(node)) {
        return convertScopeTraversalExpressionToTs(scope, node);
    }
    if (hcl2json_2.TFExpressionSyntaxTree.isUnaryOpExpression(node)) {
        return convertUnaryOpExpressionToTs(scope, node);
    }
    if (hcl2json_2.TFExpressionSyntaxTree.isBinaryOpExpression(node)) {
        return convertBinaryOpExpressionToTs(scope, node);
    }
    if (hcl2json_2.TFExpressionSyntaxTree.isTemplateExpression(node) || hcl2json_2.TFExpressionSyntaxTree.isTemplateWrapExpression(node)) {
        return convertTemplateExpressionToTs(scope, node);
    }
    if (hcl2json_2.TFExpressionSyntaxTree.isObjectExpression(node)) {
        return convertObjectExpressionToTs(scope, node);
    }
    if (hcl2json_2.TFExpressionSyntaxTree.isFunctionCallExpression(node)) {
        return convertFunctionCallExpressionToTs(scope, node);
    }
    if (hcl2json_2.TFExpressionSyntaxTree.isIndexExpression(node)) {
        return convertIndexExpressionToTs(scope, node);
    }
    if (hcl2json_2.TFExpressionSyntaxTree.isSplatExpression(node)) {
        return convertSplatExpressionToTs(scope, node);
    }
    if (hcl2json_2.TFExpressionSyntaxTree.isConditionalExpression(node)) {
        return convertConditionalExpressionToTs(scope, node);
    }
    if (hcl2json_2.TFExpressionSyntaxTree.isTupleExpression(node)) {
        return convertTupleExpressionToTs(scope, node);
    }
    if (hcl2json_2.TFExpressionSyntaxTree.isRelativeTraversalExpression(node)) {
        return convertRelativeTraversalExpressionToTs(scope, node);
    }
    if (hcl2json_2.TFExpressionSyntaxTree.isForExpression(node)) {
        return convertForExpressionToTs(scope, node);
    }
    return t.stringLiteral("");
}
async function expressionAst(input) {
    const { wrap, wrapOffset } = (0, hcl2json_2.wrapTerraformExpression)(input);
    const ast = await (0, hcl2json_1.getExpressionAst)("main.tf", wrap);
    if (!ast) {
        throw new Error(`Unable to parse terraform expression: ${input}`);
    }
    if (wrapOffset != 0 && hcl2json_2.TFExpressionSyntaxTree.isTemplateWrapExpression(ast)) {
        return ast.children[0];
    }
    return ast;
}
exports.expressionAst = expressionAst;
async function convertTerraformExpressionToTs(scope, input, targetType) {
    utils_1.logger.debug(`convertTerraformExpressionToTs(${input})`);
    const tsExpression = convertTFExpressionAstToTs(scope, await expressionAst(input));
    return (0, coerceType_1.coerceType)(scope, tsExpression, (0, coerceType_1.findExpressionType)(scope, tsExpression), targetType());
}
exports.convertTerraformExpressionToTs = convertTerraformExpressionToTs;
async function extractIteratorVariablesFromExpression(input) {
    const possibleVariableSpots = await (0, hcl2json_1.getReferencesInExpression)("main.tf", input);
    return possibleVariableSpots
        .filter((spot) => spot.value.startsWith("each."))
        .map((spot) => ({
        start: spot.startPosition,
        end: spot.endPosition,
        value: spot.value,
    }));
}
exports.extractIteratorVariablesFromExpression = extractIteratorVariablesFromExpression;
function dynamicVariableToAst(scope, node, iteratorName, block = "each") {
    if (iteratorName === "dynamic-block") {
        return expressionForSerialStringConcatenation(scope, [
            t.stringLiteral("${"),
            t.stringLiteral(block),
            t.stringLiteral("}"),
        ]);
    }
    if (node.meta.value === `${block}.key`) {
        return t.memberExpression(t.identifier(iteratorName), t.identifier("key"));
    }
    if (node.meta.value === `${block}.value`) {
        return t.memberExpression(t.identifier(iteratorName), t.identifier("value"));
    }
    if (block === "count" && node.meta.value === `${block}.index`) {
        return t.memberExpression(t.identifier(iteratorName), t.identifier("index"));
    }
    const segments = node.meta.traversal;
    if (segments.length > 2 &&
        segments[0].segment === block &&
        segments[1].segment === "value") {
        const segmentsAfterEachValue = segments.slice(2);
        scope.importables.push({
            constructName: "Fn",
            provider: "cdktf",
        });
        const callee = t.memberExpression(t.identifier("Fn"), t.identifier("lookupNested"));
        return t.callExpression(callee, [
            t.memberExpression(t.identifier(iteratorName), t.identifier("value")),
            t.arrayExpression(segmentsAfterEachValue.map((part) => {
                if (part.type === "nameTraversal") {
                    return t.stringLiteral(part.segment);
                }
                else {
                    return t.stringLiteral(`[${part.segment}]`);
                }
            })),
        ]);
    }
    throw new Error(`Can not create AST for iterator variable of '${node.meta.value}'`);
}
exports.dynamicVariableToAst = dynamicVariableToAst;
//# sourceMappingURL=data:application/json;base64,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