"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractDynamicBlocks = exports.isNestedDynamicBlock = void 0;
function isNestedDynamicBlock(dynBlocks, block) {
    return dynBlocks.some((dyn) => dyn.path !== block.path && block.path.startsWith(dyn.path));
}
exports.isNestedDynamicBlock = isNestedDynamicBlock;
const extractDynamicBlocks = (config, path = "") => {
    if (typeof config !== "object") {
        return [];
    }
    if (!config) {
        return [];
    }
    if (Array.isArray(config)) {
        return config.reduce((carry, item, index) => [
            ...carry,
            ...(0, exports.extractDynamicBlocks)(item, `${path}.${index}`),
        ], []);
    }
    if ("dynamic" in config) {
        const dynamic = config.dynamic;
        const scopedVar = Object.keys(dynamic)[0];
        const { for_each, content } = dynamic[scopedVar][0];
        return [
            {
                path: `${path}.dynamic.${scopedVar}`,
                for_each,
                content,
                scopedVar,
            },
            ...(0, exports.extractDynamicBlocks)(content, `${path}.dynamic.${scopedVar}.0.content`),
        ];
    }
    return Object.entries(config).reduce((carry, [key, value]) => {
        return [...carry, ...(0, exports.extractDynamicBlocks)(value, `${path}.${key}`)];
    }, []);
};
exports.extractDynamicBlocks = extractDynamicBlocks;
//# sourceMappingURL=data:application/json;base64,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