"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const terraformSchema_1 = require("../terraformSchema");
describe("getTypeAtPath", () => {
    const schema = {
        provider_schemas: {
            test: {
                provider: {},
                data_source_schemas: {},
                resource_schemas: {
                    test_resource: {
                        version: 1,
                        block: {
                            attributes: {
                                stringAttribute: {
                                    type: "string",
                                },
                                numberAttribute: {
                                    type: "number",
                                },
                                booleanAttribute: {
                                    type: "bool",
                                },
                                stringListAttribute: {
                                    type: ["list", "string"],
                                },
                                stringSetAttribute: {
                                    type: ["set", "string"],
                                },
                                stringMapAttribute: {
                                    type: ["map", "string"],
                                },
                                stringListListAttribute: {
                                    type: ["list", ["list", "string"]],
                                },
                                objectAttribute: {
                                    type: [
                                        "object",
                                        {
                                            stringAttribute: "string",
                                        },
                                    ],
                                },
                            },
                            block_types: {
                                listMode: {
                                    nesting_mode: "list",
                                    block: {
                                        attributes: {
                                            stringAttribute: {
                                                type: "string",
                                            },
                                        },
                                        block_types: {
                                            listMode: {
                                                nesting_mode: "list",
                                                block: {
                                                    attributes: {
                                                        stringAttribute: {
                                                            type: "string",
                                                        },
                                                    },
                                                    block_types: {},
                                                },
                                            },
                                        },
                                    },
                                },
                            },
                        },
                    },
                },
            },
        },
    };
    it("should return null if it can not find the resource", () => {
        expect((0, terraformSchema_1.getTypeAtPath)(schema, "test.nonExistantResource")).toBeNull();
    });
    it("should return null if it can not find the attribute on the resource", () => {
        expect((0, terraformSchema_1.getTypeAtPath)(schema, "test.resource.ponyfoo")).toBeNull();
    });
    describe("known types", () => {
        it.each([
            ["stringAttribute", "string"],
            ["numberAttribute", "number"],
            ["booleanAttribute", "bool"],
            ["stringListAttribute", ["list", "string"]],
            ["stringSetAttribute", ["set", "string"]],
            ["stringMapAttribute", ["map", "string"]],
            ["stringMapAttribute.whateverkey", "string"],
            ["stringListListAttribute", ["list", ["list", "string"]]],
            ["stringListListAttribute.[]", ["list", "string"]],
            ["stringListListAttribute.[].[]", "string"],
            ["listMode.[].listMode.[].stringAttribute", "string"],
            ["objectAttribute.stringAttribute", "string"],
        ])(`access to %s returns %s`, (attr, res) => {
            expect((0, terraformSchema_1.getTypeAtPath)(schema, `test.resource.${attr}`)).toEqual(res);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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