"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const generation_1 = require("../generation");
const testHelpers_1 = require("./testHelpers");
describe("variableTypeToAst", () => {
    async function run(type) {
        return (0, testHelpers_1.astToCode)(await (0, generation_1.variableTypeToAst)({
            importables: [],
        }, type));
    }
    it("should convert a simple type", async () => {
        expect(await run("${string}")).toMatchInlineSnapshot(`"VariableType.STRING"`);
    });
    it("should convert a object type", async () => {
        expect(await run("${object({\n          name    = string\n          address = string\n        })}")).toMatchInlineSnapshot(`
      "VariableType.object({
        "address": VariableType.STRING,
        "name": VariableType.STRING
      })"
    `);
    });
    it("should convert a list type", async () => {
        expect(await run("${list(object({\n            internal = number\n            external = number\n            protocol = string\n        }))}")).toMatchInlineSnapshot(`
      "VariableType.list(VariableType.object({
        "external": VariableType.NUMBER,
        "internal": VariableType.NUMBER,
        "protocol": VariableType.STRING
      }))"
    `);
    });
    it("should convert a set type", async () => {
        expect(await run("${set(string)}")).toMatchInlineSnapshot(`"VariableType.set(VariableType.STRING)"`);
    });
    it("should convert a map type", async () => {
        expect(await run("${map(string)}")).toMatchInlineSnapshot(`"VariableType.map(VariableType.STRING)"`);
    });
    it("should convert a tuple type", async () => {
        expect(await run("${tuple(string, number, bool)}")).toMatchInlineSnapshot(`"VariableType.tuple(VariableType.STRING, VariableType.NUMBER, VariableType.BOOL)"`);
    });
});
//# sourceMappingURL=data:application/json;base64,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