"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const t = __importStar(require("@babel/types"));
const coerceType_1 = require("../coerceType");
const functions_1 = require("../function-bindings/functions");
const testHelpers_1 = require("./testHelpers");
const scope = {
    providerSchema: {},
    providerGenerator: {},
    constructs: new Set(),
    variables: {},
    hasTokenBasedTypeCoercion: false,
    nodeIds: [],
    importables: [],
    topLevelConfig: {},
};
// '${replace(module.foo.output, "-", var.bar)}'
// from https://github.com/hashicorp/terraform-cdk/pull/2729
const dummy2 = {
    children: [
        {
            children: [
                {
                    children: [],
                    meta: {
                        traversal: [
                            {
                                range: {
                                    End: {
                                        Byte: 16,
                                        Column: 16,
                                        Line: 0,
                                    },
                                    Filename: "",
                                    Start: {
                                        Byte: 10,
                                        Column: 10,
                                        Line: 0,
                                    },
                                },
                                segment: "module",
                            },
                            {
                                range: {
                                    End: {
                                        Byte: 20,
                                        Column: 20,
                                        Line: 0,
                                    },
                                    Filename: "",
                                    Start: {
                                        Byte: 16,
                                        Column: 16,
                                        Line: 0,
                                    },
                                },
                                segment: "foo",
                            },
                            {
                                range: {
                                    End: {
                                        Byte: 27,
                                        Column: 27,
                                        Line: 0,
                                    },
                                    Filename: "",
                                    Start: {
                                        Byte: 20,
                                        Column: 20,
                                        Line: 0,
                                    },
                                },
                                segment: "output",
                            },
                        ],
                    },
                    range: {
                        end: {
                            byte: 27,
                            column: 27,
                            line: 0,
                        },
                        start: {
                            byte: 10,
                            column: 10,
                            line: 0,
                        },
                    },
                    type: "ScopeTraversal",
                },
                {
                    children: [
                        {
                            children: [],
                            meta: {
                                type: "string",
                                value: "-",
                            },
                            range: {
                                end: {
                                    byte: 31,
                                    column: 31,
                                    line: 0,
                                },
                                start: {
                                    byte: 30,
                                    column: 30,
                                    line: 0,
                                },
                            },
                            type: "LiteralValue",
                        },
                    ],
                    range: {
                        end: {
                            byte: 31,
                            column: 31,
                            line: 0,
                        },
                        start: {
                            byte: 30,
                            column: 30,
                            line: 0,
                        },
                    },
                    type: "Template",
                },
                {
                    children: [],
                    meta: {
                        traversal: [
                            {
                                range: {
                                    End: {
                                        Byte: 37,
                                        Column: 37,
                                        Line: 0,
                                    },
                                    Filename: "",
                                    Start: {
                                        Byte: 34,
                                        Column: 34,
                                        Line: 0,
                                    },
                                },
                                segment: "var",
                            },
                            {
                                range: {
                                    End: {
                                        Byte: 41,
                                        Column: 41,
                                        Line: 0,
                                    },
                                    Filename: "",
                                    Start: {
                                        Byte: 37,
                                        Column: 37,
                                        Line: 0,
                                    },
                                },
                                segment: "bar",
                            },
                        ],
                    },
                    range: {
                        end: {
                            byte: 41,
                            column: 41,
                            line: 0,
                        },
                        start: {
                            byte: 34,
                            column: 34,
                            line: 0,
                        },
                    },
                    type: "ScopeTraversal",
                },
            ],
            meta: {
                closeParenRange: {
                    end: {
                        byte: 42,
                        column: 42,
                        line: 0,
                    },
                    start: {
                        byte: 41,
                        column: 41,
                        line: 0,
                    },
                },
                expandedFinalArgument: false,
                name: "replace",
                nameRange: {
                    end: {
                        byte: 9,
                        column: 9,
                        line: 0,
                    },
                    start: {
                        byte: 2,
                        column: 2,
                        line: 0,
                    },
                },
                openParenRange: {
                    end: {
                        byte: 10,
                        column: 10,
                        line: 0,
                    },
                    start: {
                        byte: 9,
                        column: 9,
                        line: 0,
                    },
                },
            },
            range: {
                end: {
                    byte: 10,
                    column: 10,
                    line: 0,
                },
                start: {
                    byte: 2,
                    column: 2,
                    line: 0,
                },
            },
            type: "function",
        },
    ],
    range: {
        end: {
            byte: 43,
            column: 43,
            line: 0,
        },
        start: {
            byte: 0,
            column: 0,
            line: 0,
        },
    },
    type: "TemplateWrap",
};
describe("bindings for Terraform functions", () => {
    it("should convert Terraform AST into TS AST", () => {
        expect((0, testHelpers_1.astToCode)(terraformThingToTs(scope, dummy2, "dynamic"))).toMatchInlineSnapshot(`"Fn.replace(TodoReference-module-foo-output, "-", TodoReference-var-bar)"`);
    });
    it("should convert Terraform AST into TS AST for overriden function name", () => {
        expect((0, testHelpers_1.astToCode)(terraformThingToTs(scope, {
            type: "function",
            meta: {
                name: "length",
            },
            children: [
                {
                    type: "ScopeTraversal",
                    meta: {
                        traversal: [
                            {
                                segment: "var",
                            },
                            {
                                segment: "list",
                            },
                        ],
                    },
                    children: [],
                },
            ],
        }, "number"))).toMatchInlineSnapshot(`"Fn.lengthOf(TodoReference-var-list)"`);
    });
    it("should convert Terraform AST into TS AST for overriden function with variadic args for optional params", () => {
        expect((0, testHelpers_1.astToCode)(terraformThingToTs(scope, {
            type: "function",
            meta: {
                name: "bcrypt",
            },
            children: [
                {
                    type: "ScopeTraversal",
                    meta: {
                        traversal: [
                            {
                                segment: "var",
                            },
                            {
                                segment: "str",
                            },
                        ],
                    },
                    children: [],
                },
                {
                    type: "ScopeTraversal",
                    meta: {
                        traversal: [
                            {
                                segment: "var",
                            },
                            {
                                segment: "cost",
                            },
                        ],
                    },
                    children: [],
                },
            ],
        }, "string"))).toMatchInlineSnapshot(`"Fn.bcrypt(TodoReference-var-str, TodoReference-var-cost)"`);
    });
    it("should convert Terraform AST into TS AST for overriden function with variadic args for optional params that are not passed", () => {
        expect((0, testHelpers_1.astToCode)(terraformThingToTs(scope, {
            type: "function",
            meta: {
                name: "bcrypt",
            },
            children: [
                {
                    type: "ScopeTraversal",
                    meta: {
                        traversal: [
                            {
                                segment: "var",
                            },
                            {
                                segment: "str",
                            },
                        ],
                    },
                    children: [],
                },
            ],
        }, "string"))).toMatchInlineSnapshot(`"Fn.bcrypt(TodoReference-var-str)"`);
    });
    it("should convert Terraform AST into TS AST for function with variadic param", () => {
        expect((0, testHelpers_1.astToCode)(terraformThingToTs(scope, {
            type: "function",
            meta: {
                name: "try",
            },
            children: [
                {
                    type: "ScopeTraversal",
                    meta: {
                        traversal: [
                            {
                                segment: "var",
                            },
                            {
                                segment: "strA",
                            },
                        ],
                    },
                    children: [],
                },
                {
                    type: "ScopeTraversal",
                    meta: {
                        traversal: [
                            {
                                segment: "var",
                            },
                            {
                                segment: "strB",
                            },
                        ],
                    },
                    children: [],
                },
            ],
        }, "dynamic"))).toMatchInlineSnapshot(`"Fn.try([TodoReference-var-strA, TodoReference-var-strB])"`);
    });
    it("should convert Terraform AST into TS AST for join function with single list param", () => {
        expect((0, testHelpers_1.astToCode)(terraformThingToTs(scope, {
            type: "function",
            meta: {
                name: "join",
            },
            children: [
                {
                    type: "ScopeTraversal",
                    meta: {
                        traversal: [
                            {
                                segment: "var",
                            },
                            {
                                segment: "str",
                            },
                        ],
                    },
                    children: [],
                },
                {
                    type: "ScopeTraversal",
                    meta: {
                        traversal: [
                            {
                                segment: "var",
                            },
                            {
                                segment: "list",
                            },
                        ],
                    },
                    children: [],
                },
            ],
        }, "string"))).toMatchInlineSnapshot(`"Fn.join(TodoReference-var-str, TodoReference-var-list)"`);
    });
    it("should convert Terraform AST into TS AST for join function with multiple list params", () => {
        expect((0, testHelpers_1.astToCode)(terraformThingToTs(scope, {
            type: "function",
            meta: {
                name: "join",
            },
            children: [
                {
                    type: "ScopeTraversal",
                    meta: {
                        traversal: [
                            {
                                segment: "var",
                            },
                            {
                                segment: "str",
                            },
                        ],
                    },
                    children: [],
                },
                {
                    type: "ScopeTraversal",
                    meta: {
                        traversal: [
                            {
                                segment: "var",
                            },
                            {
                                segment: "listA",
                            },
                        ],
                    },
                    children: [],
                },
                {
                    type: "ScopeTraversal",
                    meta: {
                        traversal: [
                            {
                                segment: "var",
                            },
                            {
                                segment: "listB",
                            },
                        ],
                    },
                    children: [],
                },
            ],
        }, "string"))).toMatchInlineSnapshot(`"Fn.join(TodoReference-var-str, Token.asList(Fn.concat([TodoReference-var-listA, TodoReference-var-listB])))"`);
    });
    it("should throw if not enough parameters were passed", () => {
        expect(() => (0, testHelpers_1.astToCode)(terraformThingToTs(scope, {
            type: "function",
            meta: {
                name: "bcrypt",
            },
            children: [],
        }, "string"))).toThrowErrorMatchingInlineSnapshot(`"Terraform function call to "bcrypt" is not valid! Parameter at index 0 of type string is not optional but received no value. The following parameters were passed: []"`);
    });
    // TODO: tests for type coercion
});
function terraformThingToTs(scope, tfAst, targetType) {
    switch (tfAst.type) {
        case "function": {
            return terraformFunctionCallToTs(scope, tfAst, targetType);
        }
        case "TemplateWrap": {
            // If there's just one child, we can skip them
            if (tfAst.children.length === 1) {
                return terraformThingToTs(scope, tfAst.children[0], targetType);
            }
            throw new Error("TemplateWrap with not exactly one child is not supported yet: " +
                tfAst.children);
        }
        case "ScopeTraversal": {
            return terraformScopeTraversalToTs(tfAst, targetType);
        }
        case "Template": {
            return terraformTemplateToTs(scope, tfAst, targetType);
        }
        case "LiteralValue": {
            return terraformLiteralValueToTs(tfAst, targetType);
        }
        default:
            throw new Error("Unsupported type: " + tfAst.type);
    }
}
function terraformScopeTraversalToTs(tfAst, _targetType) {
    return t.identifier("TodoReference-" + tfAst.meta.traversal.map((t) => t.segment).join("-"));
}
function terraformTemplateToTs(scope, tfAst, targetType) {
    if (tfAst.children.length === 1) {
        return terraformThingToTs(scope, tfAst.children[0], targetType);
    }
    throw new Error("Template currently only supports exactly one child");
}
function terraformLiteralValueToTs(tfAst, targetType) {
    const literalExpression = t.stringLiteral(tfAst.meta.value);
    return (0, coerceType_1.coerceType)(
    // TODO: scope should be passed instead, even if coerceType won't need it probably
    {
        constructs: new Set(),
        hasTokenBasedTypeCoercion: false,
        providerGenerator: {},
        providerSchema: {},
        variables: {},
        nodeIds: [],
        importables: [],
        topLevelConfig: {},
    }, literalExpression, tfAst.meta.type, targetType);
}
function terraformFunctionCallToTs(scope, tfAst, targetType) {
    const { name } = tfAst.meta;
    const mapping = functions_1.functionsMap[name];
    if (!mapping) {
        throw new Error(`Mapping not found for function: ${name}`);
    }
    if (mapping.transformer) {
        const newTfAst = mapping.transformer(tfAst);
        if (newTfAst !== tfAst)
            return terraformFunctionCallToTs(scope, newTfAst, targetType);
    }
    scope.importables.push({
        constructName: "Fn",
        provider: "cdktf",
    });
    const callee = t.memberExpression(t.identifier("Fn"), t.identifier(mapping.name));
    const args = [];
    mapping.parameters.forEach((param, idx) => {
        if (param.variadic) {
            // return an array with all remaining children (each mapped accordingly)
            args.push(t.arrayExpression(tfAst.children
                .slice(idx)
                .map((child) => terraformThingToTs(scope, child, param.type))));
        }
        else {
            const child = tfAst.children[idx];
            if (child) {
                args.push(terraformThingToTs(scope, child, param.type));
            }
            else if (!param.optional) {
                throw new Error(`Terraform function call to "${name}" is not valid! Parameter at index ${idx} of type ${param.type} is not optional but received no value. The following parameters were passed: ${JSON.stringify(tfAst.children)}`);
            }
        }
    });
    const returnType = mapping.returnType;
    const callExpression = t.callExpression(callee, args);
    return (0, coerceType_1.coerceType)(
    // TODO: scope should be passed instead, even if coerceType won't need it probably
    {
        constructs: new Set(),
        hasTokenBasedTypeCoercion: false,
        providerGenerator: {},
        providerSchema: {},
        variables: {},
        nodeIds: [],
        importables: [],
        topLevelConfig: {},
    }, callExpression, returnType, targetType);
}
//# sourceMappingURL=data:application/json;base64,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