"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const expressions_1 = require("../expressions");
const coerceType_1 = require("../coerceType");
const s3BucketSchema = {
    format_version: "1.0",
    provider_schemas: {
        "registry.terraform.io/hashicorp/aws": {
            provider: {},
            resource_schemas: {
                aws_s3_bucket: {
                    version: 0,
                    block: {
                        attributes: {
                            bucket: {
                                type: "string",
                                description_kind: "plain",
                                optional: true,
                                computed: true,
                            },
                            id: {
                                type: "string",
                                description_kind: "plain",
                                optional: true,
                                computed: true,
                            },
                            tags: {
                                type: ["map", "string"],
                                description_kind: "plain",
                                optional: true,
                            },
                            website_domain: {
                                type: "string",
                                description_kind: "plain",
                                deprecated: true,
                                computed: true,
                            },
                            website_endpoint: {
                                type: "string",
                                description_kind: "plain",
                                deprecated: true,
                                computed: true,
                            },
                        },
                        block_types: {
                            cors_rule: {
                                nesting_mode: "list",
                                block: {
                                    attributes: {
                                        allowed_headers: {
                                            type: ["list", "string"],
                                            description_kind: "plain",
                                            optional: true,
                                        },
                                    },
                                    description_kind: "plain",
                                    deprecated: true,
                                },
                            },
                        },
                    },
                },
            },
            data_source_schemas: {},
        },
    },
};
const variable = (fullName) => {
    const [resource, variableName] = fullName.split(".");
    return {
        [variableName]: {
            resource,
            variableName,
        },
    };
};
const variables = {
    ...variable("var.test"),
    ...variable("aws_s3_bucket.examplebucket"),
};
describe("findExpressionType", () => {
    it.each([
        ['"${each.key}"', "string"],
        ['"${each.value}"', "string"],
        ['"${var.test}"', "dynamic"],
        ['"${var.test}"', "dynamic"],
        ["22", "number"],
        ["true", "bool"],
        ['"hello"', "string"],
        ['"${aws_s3_bucket.examplebucket.bucket}"', "string"],
    ])("finds type for %s as %s", async (input, expected) => {
        const scope = {
            variables,
            providerSchema: s3BucketSchema,
        };
        const ast = await (0, expressions_1.convertTerraformExpressionToTs)(scope, input, () => "dynamic");
        const result = (0, coerceType_1.findExpressionType)(scope, ast);
        expect(result).toEqual(expected);
    });
});
//# sourceMappingURL=data:application/json;base64,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