"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.format = format;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
// eslint-disable-next-line @typescript-eslint/triple-slash-reference
/// <reference lib="dom" />
const fs = __importStar(require("fs-extra"));
const path_1 = require("path");
const zlib_1 = require("zlib");
// eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
const jsRoot = {};
function sleep() {
    return new Promise((resolve) => {
        setTimeout(resolve, 0);
    });
}
function goBridge(getBytes) {
    let ready = false;
    async function init() {
        // After: https://github.com/golang/go/commit/680caf15355057ca84857a2a291b6f5c44e73329
        // Go 1.19+ has a different entrypoint
        await Promise.resolve().then(() => __importStar(require(`../wasm/bridge_wasm_exec.js`)));
        const go = new global.Go();
        const bytes = await getBytes;
        const result = await WebAssembly.instantiate(bytes, go.importObject);
        global.__hcl_helpers_config_wasm__ = jsRoot;
        void go.run(result.instance);
        ready = true;
    }
    init().catch((error) => {
        throw error;
    });
    const proxy = new Proxy({}, {
        get: (_, key) => {
            return async (...args) => {
                while (!ready) {
                    await sleep();
                }
                if (!(key in jsRoot)) {
                    throw new Error(`There is nothing defined with the name "${key.toString()}"`);
                }
                if (typeof jsRoot[key] !== "function") {
                    return jsRoot[key];
                }
                return new Promise((resolve, reject) => {
                    const cb = (err, ...msg) => 
                    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
                    // @ts-ignore
                    err ? reject(new Error(err)) : resolve(...msg);
                    const run = () => {
                        jsRoot[key].apply(undefined, [...args, cb]);
                    };
                    run();
                });
            };
        },
    });
    return proxy;
}
const loadWasm = async () => {
    return (0, zlib_1.gunzipSync)(await fs.readFile((0, path_1.join)(__dirname, "..", "main.wasm.gz")));
};
const wasm = goBridge(loadWasm());
async function format(contents) {
    const res = await wasm.format(contents);
    return res;
}
//# sourceMappingURL=data:application/json;base64,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