"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasNoColorFlagOrEnv = exports.ensureAllSettledBeforeThrowing = exports.downloadFile = exports.HttpError = exports.downcaseFirst = exports.readCDKTFManifest = exports.readCDKTFVersion = exports.exec = exports.mkdtemp = exports.withTempDir = exports.shell = void 0;
const cross_spawn_1 = require("cross-spawn");
const fs = __importStar(require("fs-extra"));
const follow_redirects_1 = require("follow-redirects");
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const logging_1 = require("./logging");
const cdktf_1 = require("cdktf");
const config = __importStar(require("./config"));
const strip_ansi_1 = __importDefault(require("strip-ansi"));
async function shell(program, args = [], options = {}) {
    const stderr = new Array();
    const stdout = new Array();
    try {
        return await (0, exports.exec)(program, args, options, (chunk) => {
            const sanitizedChunk = options.noColor
                ? (0, strip_ansi_1.default)(chunk.toLocaleString())
                : chunk.toLocaleString();
            stdout.push(sanitizedChunk);
            console.log(sanitizedChunk);
        }, (chunk) => {
            const sanitizedChunk = options.noColor
                ? (0, strip_ansi_1.default)(chunk.toLocaleString())
                : chunk.toLocaleString();
            stderr.push(sanitizedChunk);
        });
    }
    catch (e) {
        if (stderr.length > 0) {
            e.stderr = stderr.map((chunk) => chunk.toString()).join("");
            if (options.noColor) {
                e.stderr = (0, strip_ansi_1.default)(e.stderr);
            }
        }
        if (stdout.length > 0) {
            e.stdout = stdout.join("");
            if (options.noColor) {
                e.stdout = (0, strip_ansi_1.default)(e.stdout);
            }
        }
        throw e;
    }
}
exports.shell = shell;
async function withTempDir(dirname, closure) {
    const prevdir = process.cwd();
    const parent = await fs.mkdtemp(path.join(os.tmpdir(), "cdktf."));
    const workdir = path.join(parent, dirname);
    await fs.mkdirp(workdir);
    try {
        process.chdir(workdir);
        await closure();
    }
    finally {
        process.chdir(prevdir);
        await fs.remove(parent);
    }
}
exports.withTempDir = withTempDir;
async function mkdtemp(closure) {
    const workdir = await fs.mkdtemp(path.join(os.tmpdir(), "cdktf."));
    try {
        await closure(workdir);
    }
    finally {
        await fs.remove(workdir);
    }
}
exports.mkdtemp = mkdtemp;
const exec = async (command, args, options, stdout, stderr, sendToStderr = true) => {
    // if options.noColor is not set, checking the flags & environment if it should be set
    // This is required for collectDebugInformation() which does not have knowledge about flags
    if (typeof options.noColor !== "boolean" && hasNoColorFlagOrEnv()) {
        options.noColor = true;
    }
    return new Promise((ok, ko) => {
        var _a, _b, _c, _d;
        const child = (0, cross_spawn_1.spawn)(command, args, options);
        const out = new Array();
        const err = new Array();
        if (stdout !== undefined) {
            (_a = child.stdout) === null || _a === void 0 ? void 0 : _a.on("data", (chunk) => {
                const sanitizedChunk = options.noColor
                    ? (0, strip_ansi_1.default)(chunk.toLocaleString())
                    : chunk.toLocaleString();
                (0, logging_1.processLoggerDebug)(sanitizedChunk);
                out.push(sanitizedChunk);
                stdout(sanitizedChunk);
            });
        }
        else {
            (_b = child.stdout) === null || _b === void 0 ? void 0 : _b.on("data", (chunk) => {
                const sanitizedChunk = options.noColor
                    ? (0, strip_ansi_1.default)(chunk.toLocaleString())
                    : chunk.toLocaleString();
                (0, logging_1.processLoggerDebug)(sanitizedChunk);
                out.push(sanitizedChunk);
            });
        }
        if (stderr !== undefined) {
            (_c = child.stderr) === null || _c === void 0 ? void 0 : _c.on("data", (chunk) => {
                const sanitizedChunk = options.noColor
                    ? (0, strip_ansi_1.default)(chunk.toLocaleString())
                    : chunk.toLocaleString();
                (0, logging_1.processLoggerError)(sanitizedChunk);
                if (sendToStderr) {
                    stderr(sanitizedChunk);
                }
                err.push(sanitizedChunk);
            });
        }
        else {
            (_d = child.stderr) === null || _d === void 0 ? void 0 : _d.on("data", (chunk) => {
                const sanitizedChunk = options.noColor
                    ? (0, strip_ansi_1.default)(chunk.toLocaleString())
                    : chunk.toLocaleString();
                (0, logging_1.processLoggerError)(sanitizedChunk);
                if (sendToStderr) {
                    process.stderr.write(sanitizedChunk);
                }
                err.push(sanitizedChunk);
            });
        }
        child.once("error", (err) => ko(err));
        child.once("close", (code) => {
            if (code !== 0) {
                const error = new Error(`non-zero exit code ${code}`);
                error.stderr = err.map((chunk) => chunk.toString()).join("");
                return ko(error);
            }
            return ok(out.join(""));
        });
    });
};
exports.exec = exec;
async function readCDKTFVersion(outputDir) {
    const outputFile = path.join(outputDir, "cdk.tf.json");
    if (fs.existsSync(outputFile)) {
        const outputJSON = fs.readFileSync(outputFile, "utf8");
        const data = JSON.parse(outputJSON);
        return data["//"].metadata.version;
    }
    return "";
}
exports.readCDKTFVersion = readCDKTFVersion;
async function readCDKTFManifest() {
    const { output } = config.readConfigSync();
    const json = await fs.readFile(path.join(output, cdktf_1.Manifest.fileName));
    return JSON.parse(json.toString());
}
exports.readCDKTFManifest = readCDKTFManifest;
/**
 * Downcase the first character in a string.
 *
 * @param str the string to be processed.
 */
function downcaseFirst(str) {
    if (str === "") {
        return str;
    }
    return `${str[0].toLocaleLowerCase()}${str.slice(1)}`;
}
exports.downcaseFirst = downcaseFirst;
class HttpError extends Error {
    constructor(message, statusCode) {
        super(message); // 'Error' breaks prototype chain here
        this.statusCode = statusCode;
        Object.setPrototypeOf(this, new.target.prototype); // restore prototype chain
        // see: https://www.typescriptlang.org/docs/handbook/release-notes/typescript-2-2.html#support-for-newtarget
    }
}
exports.HttpError = HttpError;
async function downloadFile(url, targetFilename) {
    // if the type is inferred to be "http|https" calling .get() is not possible
    // because the options parameter (which we don't use anyway) for get is
    // not compatible between http and https -> so we treat it as http
    const client = (url.startsWith("http://") ? follow_redirects_1.http : follow_redirects_1.https);
    const file = fs.createWriteStream(targetFilename);
    return new Promise((ok, ko) => {
        const request = client.get(url, (response) => {
            if (response.statusCode !== 200) {
                ko(new HttpError(`Failed to get '${url}' (${response.statusCode})`, response.statusCode));
                return;
            }
            response.pipe(file);
        });
        file.on("finish", () => ok());
        request.on("error", (err) => {
            fs.unlink(targetFilename, () => ko(err));
        });
        file.on("error", (err) => {
            fs.unlink(targetFilename, () => ko(err));
        });
        request.end();
    });
}
exports.downloadFile = downloadFile;
/**
 * Awaits a promise and makes sure it's error (if any) is only thrown after all other promises are settled
 * if the promise does not throw an error, the other promises won't be awaited
 * @param p promise to await
 * @param promises promises to await to be all settled if p failed before throwing error that p failed with
 */
async function ensureAllSettledBeforeThrowing(p, promises) {
    try {
        await p;
    }
    catch (e) {
        // if an error happened, we still need to wait for all other promises that
        // are currently in progress to complete to allow them to properly wrap up
        await Promise.allSettled(promises);
        throw e;
    }
}
exports.ensureAllSettledBeforeThrowing = ensureAllSettledBeforeThrowing;
/**
 * returns true if --no-color is passed as CLI flag or the env var FORCE_COLOR is set to "0"
 * Used for cases where we can't pass down the noColor flag (e.g. when collecting debug information from the environment)
 * This is the same behavior as the `chalk` lib we use for coloring output
 */
function hasNoColorFlagOrEnv() {
    return hasFlag("no-color") || process.env.FORCE_COLOR === "0";
}
exports.hasNoColorFlagOrEnv = hasNoColorFlagOrEnv;
// From: https://github.com/sindresorhus/has-flag/blob/main/index.js
// as used in https://github.com/chalk/chalk
function hasFlag(flag) {
    const prefix = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
    const position = process.argv.indexOf(prefix + flag);
    const terminatorPosition = process.argv.indexOf("--");
    return (position !== -1 &&
        (terminatorPosition === -1 || position < terminatorPosition));
}
//# sourceMappingURL=data:application/json;base64,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