/// <reference types="ambient" />
/// <reference types="node/child_process" />
import { SpawnOptions } from "child_process";
import { IManifest } from "cdktf";
export declare function shell(program: string, args?: string[], options?: SpawnOptions & {
    noColor?: boolean;
}): Promise<string>;
export declare function withTempDir(dirname: string, closure: () => Promise<void>): Promise<void>;
export declare function mkdtemp(closure: (dir: string) => Promise<void>): Promise<void>;
export declare const exec: (command: string, args: string[], options: SpawnOptions & {
    noColor?: boolean;
}, stdout?: (chunk: string) => any, stderr?: (chunk: string | Uint8Array) => any, sendToStderr?: boolean) => Promise<string>;
export declare function readCDKTFVersion(outputDir: string): Promise<string>;
export declare function readCDKTFManifest(): Promise<IManifest>;
/**
 * Downcase the first character in a string.
 *
 * @param str the string to be processed.
 */
export declare function downcaseFirst(str: string): string;
export declare class HttpError extends Error {
    statusCode?: number | undefined;
    constructor(message?: string, statusCode?: number | undefined);
}
export declare function downloadFile(url: string, targetFilename: string): Promise<void>;
/**
 * Awaits a promise and makes sure it's error (if any) is only thrown after all other promises are settled
 * if the promise does not throw an error, the other promises won't be awaited
 * @param p promise to await
 * @param promises promises to await to be all settled if p failed before throwing error that p failed with
 */
export declare function ensureAllSettledBeforeThrowing(p: Promise<any>, promises: (Promise<any> | undefined)[]): Promise<void>;
/**
 * returns true if --no-color is passed as CLI flag or the env var FORCE_COLOR is set to "0"
 * Used for cases where we can't pass down the noColor flag (e.g. when collecting debug information from the environment)
 * This is the same behavior as the `chalk` lib we use for coloring output
 */
export declare function hasNoColorFlagOrEnv(): boolean;
//# sourceMappingURL=util.d.ts.map