"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.terraformVersion = exports.terraformBinaryName = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const errors_1 = require("./errors");
const util_1 = require("./util");
exports.terraformBinaryName = process.env.TERRAFORM_BINARY_NAME || "terraform";
exports.terraformVersion = (0, util_1.exec)(exports.terraformBinaryName, ["version", "-json"], {})
    .then((versionString) => JSON.parse(versionString).terraform_version)
    .catch((err) => errors_1.Errors.Usage(`Unknown: Error loading terraform version ${err}`, err));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVycmFmb3JtLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidGVycmFmb3JtLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLCtCQUErQjtBQUMvQixtQ0FBbUM7QUFDbkMscUNBQWtDO0FBQ2xDLGlDQUE4QjtBQUVqQixRQUFBLG1CQUFtQixHQUM5QixPQUFPLENBQUMsR0FBRyxDQUFDLHFCQUFxQixJQUFJLFdBQVcsQ0FBQztBQUN0QyxRQUFBLGdCQUFnQixHQUFHLElBQUEsV0FBSSxFQUNsQywyQkFBbUIsRUFDbkIsQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLEVBQ3BCLEVBQUUsQ0FDSDtLQUNFLElBQUksQ0FBQyxDQUFDLGFBQWEsRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsQ0FBQyxpQkFBaUIsQ0FBQztLQUNwRSxLQUFLLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUNiLGVBQU0sQ0FBQyxLQUFLLENBQUMsNENBQTRDLEdBQUcsRUFBRSxFQUFFLEdBQUcsQ0FBQyxDQUNyRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSBIYXNoaUNvcnAsIEluY1xuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1QTC0yLjBcbmltcG9ydCB7IEVycm9ycyB9IGZyb20gXCIuL2Vycm9yc1wiO1xuaW1wb3J0IHsgZXhlYyB9IGZyb20gXCIuL3V0aWxcIjtcblxuZXhwb3J0IGNvbnN0IHRlcnJhZm9ybUJpbmFyeU5hbWUgPVxuICBwcm9jZXNzLmVudi5URVJSQUZPUk1fQklOQVJZX05BTUUgfHwgXCJ0ZXJyYWZvcm1cIjtcbmV4cG9ydCBjb25zdCB0ZXJyYWZvcm1WZXJzaW9uID0gZXhlYyhcbiAgdGVycmFmb3JtQmluYXJ5TmFtZSxcbiAgW1widmVyc2lvblwiLCBcIi1qc29uXCJdLFxuICB7fSxcbilcbiAgLnRoZW4oKHZlcnNpb25TdHJpbmcpID0+IEpTT04ucGFyc2UodmVyc2lvblN0cmluZykudGVycmFmb3JtX3ZlcnNpb24pXG4gIC5jYXRjaCgoZXJyKSA9PlxuICAgIEVycm9ycy5Vc2FnZShgVW5rbm93bjogRXJyb3IgbG9hZGluZyB0ZXJyYWZvcm0gdmVyc2lvbiAke2Vycn1gLCBlcnIpLFxuICApO1xuIl19