"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const terraform_module_1 = require("./terraform-module");
describe("terraform-module", () => {
    describe.each `
    source                                                        | expected
    ${"hashicorp/consul/aws"}                                     | ${true}
    ${"hashicorp/consul/aws//foo"}                                | ${false}
    ${"./consul"}                                                 | ${false}
    ${"git@github.com:hashicorp/example.git"}                     | ${false}
    ${"github.com/hashicorp/example"}                             | ${false}
    ${"github.com/hashicorp/terraform-cidr-subnets"}              | ${false}
    ${"bitbucket.org/hashicorp/terraform-consul-aws"}             | ${false}
    ${"foo/var/baz/qux"}                                          | ${false}
    ${"foo.com/var/baz"}                                          | ${true}
    ${".foo.com/var/baz"}                                         | ${false}
    ${"f-o-o.com/var/baz"}                                        | ${true}
    ${"foo.com/var/baz/canz"}                                     | ${true}
    ${"example.com/awesomecorp/network/happycloud//examples/foo"} | ${false}
    ${"www.googleapis.com/storage/v1/BUCKET_NAME/PATH_TO_MODULE"} | ${false}
  `("isRegistryModule($source)", ({ source, expected }) => {
        it(`expects ${expected}`, () => {
            expect((0, terraform_module_1.isRegistryModule)(source)).toBe(expected);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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