"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isRegistryModule = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const validator_1 = require("validator");
// Logic from https://github.com/hashicorp/terraform/blob/e09b831f6ee35d37b11b8dcccd3a6d6f6db5e5ff/internal/addrs/module_source.go#L198
function isRegistryModule(source) {
    const parts = source.split("/");
    if (source.startsWith(".") ||
        parts.length < 3 ||
        parts.length > 4 ||
        source.includes("github.com") ||
        source.includes("bitbucket.org")) {
        return false;
    }
    if (parts.length === 4 && !(0, validator_1.isFQDN)(parts[0])) {
        return false;
    }
    return true;
}
exports.isRegistryModule = isRegistryModule;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVycmFmb3JtLW1vZHVsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRlcnJhZm9ybS1tb2R1bGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0JBQStCO0FBQy9CLG1DQUFtQztBQUNuQyx5Q0FBbUM7QUFFbkMsdUlBQXVJO0FBQ3ZJLFNBQWdCLGdCQUFnQixDQUFDLE1BQWM7SUFDN0MsTUFBTSxLQUFLLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUNoQyxJQUNFLE1BQU0sQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDO1FBQ3RCLEtBQUssQ0FBQyxNQUFNLEdBQUcsQ0FBQztRQUNoQixLQUFLLENBQUMsTUFBTSxHQUFHLENBQUM7UUFDaEIsTUFBTSxDQUFDLFFBQVEsQ0FBQyxZQUFZLENBQUM7UUFDN0IsTUFBTSxDQUFDLFFBQVEsQ0FBQyxlQUFlLENBQUMsRUFDaEMsQ0FBQztRQUNELE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztJQUVELElBQUksS0FBSyxDQUFDLE1BQU0sS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFBLGtCQUFNLEVBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztRQUM1QyxPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7SUFFRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFqQkQsNENBaUJDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSBIYXNoaUNvcnAsIEluY1xuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1QTC0yLjBcbmltcG9ydCB7IGlzRlFETiB9IGZyb20gXCJ2YWxpZGF0b3JcIjtcblxuLy8gTG9naWMgZnJvbSBodHRwczovL2dpdGh1Yi5jb20vaGFzaGljb3JwL3RlcnJhZm9ybS9ibG9iL2UwOWI4MzFmNmVlMzVkMzdiMTFiOGRjY2NkM2E2ZDZmNmRiNWU1ZmYvaW50ZXJuYWwvYWRkcnMvbW9kdWxlX3NvdXJjZS5nbyNMMTk4XG5leHBvcnQgZnVuY3Rpb24gaXNSZWdpc3RyeU1vZHVsZShzb3VyY2U6IHN0cmluZykge1xuICBjb25zdCBwYXJ0cyA9IHNvdXJjZS5zcGxpdChcIi9cIik7XG4gIGlmIChcbiAgICBzb3VyY2Uuc3RhcnRzV2l0aChcIi5cIikgfHxcbiAgICBwYXJ0cy5sZW5ndGggPCAzIHx8XG4gICAgcGFydHMubGVuZ3RoID4gNCB8fFxuICAgIHNvdXJjZS5pbmNsdWRlcyhcImdpdGh1Yi5jb21cIikgfHxcbiAgICBzb3VyY2UuaW5jbHVkZXMoXCJiaXRidWNrZXQub3JnXCIpXG4gICkge1xuICAgIHJldHVybiBmYWxzZTtcbiAgfVxuXG4gIGlmIChwYXJ0cy5sZW5ndGggPT09IDQgJiYgIWlzRlFETihwYXJ0c1swXSkpIHtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH1cblxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==