"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNestedTypeAttribute = exports.isAttributeNestedType = void 0;
function isAttributeNestedType(type) {
    return (typeof type === "object" &&
        !Array.isArray(type) &&
        typeof type.nesting_mode === "string" &&
        (typeof type.attributes === "object" ||
            typeof type.attributes === "undefined"));
}
exports.isAttributeNestedType = isAttributeNestedType;
function isNestedTypeAttribute(att) {
    return (typeof att.nested_type !== "undefined" &&
        isAttributeNestedType(att.nested_type));
}
exports.isNestedTypeAttribute = isNestedTypeAttribute;
//# sourceMappingURL=data:application/json;base64,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