"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.logFileName = exports.processLoggerError = exports.processLoggerDebug = exports.logger = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const log4js_1 = require("log4js");
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
const Sentry = __importStar(require("@sentry/node"));
const util_1 = require("./util");
const cliLogger = (0, log4js_1.getLogger)();
const logger = {
    trace(message, ...args) {
        cliLogger.trace(message, ...args);
        Sentry.addBreadcrumb({
            message,
            level: "debug",
        });
    },
    debug(message, ...args) {
        cliLogger.debug(message, ...args);
        Sentry.addBreadcrumb({
            message,
            level: "debug",
        });
    },
    info(message, ...args) {
        cliLogger.info(message, ...args);
        Sentry.addBreadcrumb({
            message,
            level: "info",
        });
    },
    warn(message, ...args) {
        cliLogger.warn(message, ...args);
        Sentry.addBreadcrumb({
            message,
            level: "warning",
        });
    },
    error(message, ...args) {
        cliLogger.error(message, ...args);
        Sentry.addBreadcrumb({
            message,
            level: "error",
        });
    },
    fatal(message, ...args) {
        cliLogger.fatal(message, ...args);
        Sentry.addBreadcrumb({
            message,
            level: "fatal",
        });
    },
    setLevel(level) {
        cliLogger.level = level;
    },
    useDefaultLevel() {
        cliLogger.level = process.env.CDKTF_LOG_LEVEL || "INFO";
    },
};
exports.logger = logger;
cliLogger.level = process.env.CDKTF_LOG_LEVEL || "INFO";
const logFileName = "cdktf.log";
exports.logFileName = logFileName;
if (process.env.CDKTF_LOG_FILE_DIRECTORY &&
    fs.existsSync(process.env.CDKTF_LOG_FILE_DIRECTORY) &&
    fs.statSync(process.env.CDKTF_LOG_FILE_DIRECTORY).isDirectory()) {
    (0, log4js_1.configure)({
        appenders: {
            cdktf: {
                type: "file",
                filename: path.join(process.env.CDKTF_LOG_FILE_DIRECTORY, logFileName),
            },
        },
        categories: { default: { appenders: ["cdktf"], level: "debug" } },
    });
}
else {
    const layoutType = (0, util_1.hasNoColorFlagOrEnv)() ? "basic" : "colored";
    (0, log4js_1.configure)({
        appenders: { out: { type: "stdout", layout: { type: layoutType } } },
        categories: { default: { appenders: ["out"], level: "info" } },
    });
}
const processLoggerDebug = (chunk) => {
    logger.debug(chunk.toString());
};
exports.processLoggerDebug = processLoggerDebug;
const processLoggerError = (chunk) => {
    logger.error(chunk.toString());
};
exports.processLoggerError = processLoggerError;
//# sourceMappingURL=data:application/json;base64,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