/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
export declare function isGradleProject(workingDirectory: string): boolean;
export declare function getGradleDependencies(): Promise<string[] | undefined>;
export type DependencyInformation = {
    group: string;
    name: string;
    version: string;
};
export declare function getDependencyInformationFromLine(line: string): DependencyInformation | undefined;
export declare function getGradlePackageVersion(packageName: string): Promise<string | undefined>;
export declare function getGradlePackageVersionFromBuild(packageName: string): Promise<{
    group: string;
    name: string;
    version: string;
} | undefined>;
//# sourceMappingURL=gradle.d.ts.map