"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Errors = exports.IsErrorType = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const checkpoint_1 = require("./checkpoint");
const version_1 = require("./version");
const Sentry = __importStar(require("@sentry/node"));
// Errors that will emit telemetry events
async function report(command, payload) {
    const reportParams = {
        command,
        product: "cdktf",
        version: `${version_1.DISPLAY_VERSION}`,
        dateTime: new Date(),
        payload,
    };
    await (0, checkpoint_1.ReportRequest)(reportParams);
}
function IsErrorType(error, type) {
    return error && error.__type === type;
}
exports.IsErrorType = IsErrorType;
function reportPrefixedError(type, command) {
    return (message, originalError = new Error(), context) => {
        report(command, { ...context, message, type });
        const err = new Error(`${type} Error: ${message}`);
        Object.entries(context || {}).forEach(([key, value]) => {
            err[key] = value;
        });
        err.__type = type;
        err.stack = originalError.stack;
        return err;
    };
}
// The CLI only deals with one command at a time, so we can just use the same
// scope for all errors and set it once during initialization.
let errorScope = "unknown";
exports.Errors = {
    // Error within our control
    Internal: reportPrefixedError("Internal", errorScope),
    // Error in the usage
    Usage: reportPrefixedError("Usage", errorScope),
    // Error outside of our control (e.g. terraform failed)
    External: reportPrefixedError("External", errorScope),
    // Set the scope for all errors
    setScope(scope) {
        errorScope = scope;
        Sentry.configureScope((s) => s.setTransactionName(scope));
    },
};
//# sourceMappingURL=data:application/json;base64,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