"use strict";
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
// All switches based on environment variables in one place
Object.defineProperty(exports, "__esModule", { value: true });
exports.CDKTF_DISABLE_PLUGIN_CACHE_ENV = exports.CHECKPOINT_DISABLE = exports.DISABLE_VERSION_CHECK = void 0;
function envVarToBoolean(envVar) {
    return envVar === "true" || envVar === "1";
}
exports.DISABLE_VERSION_CHECK = envVarToBoolean(process.env.DISABLE_VERSION_CHECK);
// This is a Terraform global environment variable, so we can't use the same logic as the other env vars
// https://www.terraform.io/cli/commands#upgrade-and-security-bulletin-checks
exports.CHECKPOINT_DISABLE = Boolean(process.env.CHECKPOINT_DISABLE);
exports.CDKTF_DISABLE_PLUGIN_CACHE_ENV = envVarToBoolean(process.env.CDKTF_DISABLE_PLUGIN_CACHE_ENV);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW52aXJvbm1lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbnZpcm9ubWVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsK0JBQStCO0FBQy9CLG1DQUFtQztBQUNuQywyREFBMkQ7OztBQUUzRCxTQUFTLGVBQWUsQ0FBQyxNQUEwQjtJQUNqRCxPQUFPLE1BQU0sS0FBSyxNQUFNLElBQUksTUFBTSxLQUFLLEdBQUcsQ0FBQztBQUM3QyxDQUFDO0FBRVksUUFBQSxxQkFBcUIsR0FBRyxlQUFlLENBQ2xELE9BQU8sQ0FBQyxHQUFHLENBQUMscUJBQXFCLENBQ2xDLENBQUM7QUFDRix3R0FBd0c7QUFDeEcsNkVBQTZFO0FBQ2hFLFFBQUEsa0JBQWtCLEdBQUcsT0FBTyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCLENBQUMsQ0FBQztBQUU3RCxRQUFBLDhCQUE4QixHQUFHLGVBQWUsQ0FDM0QsT0FBTyxDQUFDLEdBQUcsQ0FBQyw4QkFBOEIsQ0FDM0MsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAoYykgSGFzaGlDb3JwLCBJbmNcbi8vIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBNUEwtMi4wXG4vLyBBbGwgc3dpdGNoZXMgYmFzZWQgb24gZW52aXJvbm1lbnQgdmFyaWFibGVzIGluIG9uZSBwbGFjZVxuXG5mdW5jdGlvbiBlbnZWYXJUb0Jvb2xlYW4oZW52VmFyOiBzdHJpbmcgfCB1bmRlZmluZWQpOiBib29sZWFuIHtcbiAgcmV0dXJuIGVudlZhciA9PT0gXCJ0cnVlXCIgfHwgZW52VmFyID09PSBcIjFcIjtcbn1cblxuZXhwb3J0IGNvbnN0IERJU0FCTEVfVkVSU0lPTl9DSEVDSyA9IGVudlZhclRvQm9vbGVhbihcbiAgcHJvY2Vzcy5lbnYuRElTQUJMRV9WRVJTSU9OX0NIRUNLLFxuKTtcbi8vIFRoaXMgaXMgYSBUZXJyYWZvcm0gZ2xvYmFsIGVudmlyb25tZW50IHZhcmlhYmxlLCBzbyB3ZSBjYW4ndCB1c2UgdGhlIHNhbWUgbG9naWMgYXMgdGhlIG90aGVyIGVudiB2YXJzXG4vLyBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vY2xpL2NvbW1hbmRzI3VwZ3JhZGUtYW5kLXNlY3VyaXR5LWJ1bGxldGluLWNoZWNrc1xuZXhwb3J0IGNvbnN0IENIRUNLUE9JTlRfRElTQUJMRSA9IEJvb2xlYW4ocHJvY2Vzcy5lbnYuQ0hFQ0tQT0lOVF9ESVNBQkxFKTtcblxuZXhwb3J0IGNvbnN0IENES1RGX0RJU0FCTEVfUExVR0lOX0NBQ0hFX0VOViA9IGVudlZhclRvQm9vbGVhbihcbiAgcHJvY2Vzcy5lbnYuQ0RLVEZfRElTQUJMRV9QTFVHSU5fQ0FDSEVfRU5WLFxuKTtcbiJdfQ==