"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const config_1 = require("./config");
const construct_maker_target_1 = require("./construct-maker-target");
describe("ConstructsMakerModuleTarget", () => {
    describe.each([
        {
            fqn: "cloudposse/label/null",
            names: {
                [config_1.Language.TYPESCRIPT]: "cloudposse.null",
                [config_1.Language.PYTHON]: "cloudposse.label.null",
                [config_1.Language.JAVA]: "cloudposse.label.null",
                [config_1.Language.CSHARP]: "cloudposse.label.null",
                [config_1.Language.GO]: "label",
            },
        },
        {
            fqn: "terraform-google-modules/project-factory/google",
            names: {
                [config_1.Language.TYPESCRIPT]: "terraform_google_modules.google",
                [config_1.Language.PYTHON]: "terraform_google_modules.project_factory.google",
                [config_1.Language.JAVA]: "terraform_google_modules.project_factory.google",
                [config_1.Language.CSHARP]: "terraform_google_modules.project_factory.google",
                [config_1.Language.GO]: "project_factory",
            },
        },
        {
            fqn: "terraform-aws-modules/vpc/aws@5.0.0",
            names: {
                [config_1.Language.TYPESCRIPT]: "terraform_aws_modules.aws",
                [config_1.Language.PYTHON]: "terraform_aws_modules.vpc.aws",
                [config_1.Language.JAVA]: "terraform_aws_modules.vpc.aws",
                [config_1.Language.CSHARP]: "terraform_aws_modules.vpc.aws",
                [config_1.Language.GO]: "vpc",
            },
        },
        {
            fqn: "terraform-aws-modules/eks/aws//modules/self-managed-node-group",
            names: {
                [config_1.Language.TYPESCRIPT]: "terraform_aws_modules.aws.eks.modules",
                [config_1.Language.PYTHON]: "terraform_aws_modules.eks.aws.modules.self_managed_node_group",
                [config_1.Language.JAVA]: "terraform_aws_modules.eks.aws.modules.self_managed_node_group",
                [config_1.Language.CSHARP]: "terraform_aws_modules.eks.aws.modules.self_managed_node_group",
                [config_1.Language.GO]: "self_managed_node_group",
            },
        },
        {
            fqn: {
                name: "my-local-module",
                source: "./path/to/local/terraform/module",
            },
            names: {
                [config_1.Language.TYPESCRIPT]: "my-local-module",
                [config_1.Language.PYTHON]: "my_local_module",
                [config_1.Language.JAVA]: "my_local_module",
                [config_1.Language.CSHARP]: "my_local_module",
                [config_1.Language.GO]: "my_local_module",
            },
        },
    ])("#srcMakName %#", ({ fqn, names }) => {
        it.each(Object.entries(names))(`expect name for ${JSON.stringify(fqn)} in %s to be %s`, (language, name) => {
            const constraint = new config_1.TerraformModuleConstraint(fqn);
            const target = new construct_maker_target_1.ConstructsMakerModuleTarget(constraint, language);
            expect(target.srcMakName).toBe(name);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uc3RydWN0LW1ha2VyLXRhcmdldC50ZXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29uc3RydWN0LW1ha2VyLXRhcmdldC50ZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7O0dBR0c7O0FBRUgscUNBQStEO0FBQy9ELHFFQUF1RTtBQUV2RSxRQUFRLENBQUMsNkJBQTZCLEVBQUUsR0FBRyxFQUFFO0lBQzNDLFFBQVEsQ0FBQyxJQUFJLENBQUM7UUFDWjtZQUNFLEdBQUcsRUFBRSx1QkFBdUI7WUFDNUIsS0FBSyxFQUFFO2dCQUNMLENBQUMsaUJBQVEsQ0FBQyxVQUFVLENBQUMsRUFBRSxpQkFBaUI7Z0JBQ3hDLENBQUMsaUJBQVEsQ0FBQyxNQUFNLENBQUMsRUFBRSx1QkFBdUI7Z0JBQzFDLENBQUMsaUJBQVEsQ0FBQyxJQUFJLENBQUMsRUFBRSx1QkFBdUI7Z0JBQ3hDLENBQUMsaUJBQVEsQ0FBQyxNQUFNLENBQUMsRUFBRSx1QkFBdUI7Z0JBQzFDLENBQUMsaUJBQVEsQ0FBQyxFQUFFLENBQUMsRUFBRSxPQUFPO2FBQ3ZCO1NBQ0Y7UUFDRDtZQUNFLEdBQUcsRUFBRSxpREFBaUQ7WUFDdEQsS0FBSyxFQUFFO2dCQUNMLENBQUMsaUJBQVEsQ0FBQyxVQUFVLENBQUMsRUFBRSxpQ0FBaUM7Z0JBQ3hELENBQUMsaUJBQVEsQ0FBQyxNQUFNLENBQUMsRUFBRSxpREFBaUQ7Z0JBQ3BFLENBQUMsaUJBQVEsQ0FBQyxJQUFJLENBQUMsRUFBRSxpREFBaUQ7Z0JBQ2xFLENBQUMsaUJBQVEsQ0FBQyxNQUFNLENBQUMsRUFBRSxpREFBaUQ7Z0JBQ3BFLENBQUMsaUJBQVEsQ0FBQyxFQUFFLENBQUMsRUFBRSxpQkFBaUI7YUFDakM7U0FDRjtRQUNEO1lBQ0UsR0FBRyxFQUFFLHFDQUFxQztZQUMxQyxLQUFLLEVBQUU7Z0JBQ0wsQ0FBQyxpQkFBUSxDQUFDLFVBQVUsQ0FBQyxFQUFFLDJCQUEyQjtnQkFDbEQsQ0FBQyxpQkFBUSxDQUFDLE1BQU0sQ0FBQyxFQUFFLCtCQUErQjtnQkFDbEQsQ0FBQyxpQkFBUSxDQUFDLElBQUksQ0FBQyxFQUFFLCtCQUErQjtnQkFDaEQsQ0FBQyxpQkFBUSxDQUFDLE1BQU0sQ0FBQyxFQUFFLCtCQUErQjtnQkFDbEQsQ0FBQyxpQkFBUSxDQUFDLEVBQUUsQ0FBQyxFQUFFLEtBQUs7YUFDckI7U0FDRjtRQUNEO1lBQ0UsR0FBRyxFQUFFLGdFQUFnRTtZQUNyRSxLQUFLLEVBQUU7Z0JBQ0wsQ0FBQyxpQkFBUSxDQUFDLFVBQVUsQ0FBQyxFQUFFLHVDQUF1QztnQkFDOUQsQ0FBQyxpQkFBUSxDQUFDLE1BQU0sQ0FBQyxFQUNmLCtEQUErRDtnQkFDakUsQ0FBQyxpQkFBUSxDQUFDLElBQUksQ0FBQyxFQUNiLCtEQUErRDtnQkFDakUsQ0FBQyxpQkFBUSxDQUFDLE1BQU0sQ0FBQyxFQUNmLCtEQUErRDtnQkFDakUsQ0FBQyxpQkFBUSxDQUFDLEVBQUUsQ0FBQyxFQUFFLHlCQUF5QjthQUN6QztTQUNGO1FBQ0Q7WUFDRSxHQUFHLEVBQUU7Z0JBQ0gsSUFBSSxFQUFFLGlCQUFpQjtnQkFDdkIsTUFBTSxFQUFFLGtDQUFrQzthQUMzQztZQUNELEtBQUssRUFBRTtnQkFDTCxDQUFDLGlCQUFRLENBQUMsVUFBVSxDQUFDLEVBQUUsaUJBQWlCO2dCQUN4QyxDQUFDLGlCQUFRLENBQUMsTUFBTSxDQUFDLEVBQUUsaUJBQWlCO2dCQUNwQyxDQUFDLGlCQUFRLENBQUMsSUFBSSxDQUFDLEVBQUUsaUJBQWlCO2dCQUNsQyxDQUFDLGlCQUFRLENBQUMsTUFBTSxDQUFDLEVBQUUsaUJBQWlCO2dCQUNwQyxDQUFDLGlCQUFRLENBQUMsRUFBRSxDQUFDLEVBQUUsaUJBQWlCO2FBQ2pDO1NBQ0Y7S0FDRixDQUFDLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQyxFQUFFLEdBQUcsRUFBRSxLQUFLLEVBQUUsRUFBRSxFQUFFO1FBQ3RDLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUM1QixtQkFBbUIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsaUJBQWlCLEVBQ3ZELENBQUMsUUFBUSxFQUFFLElBQUksRUFBRSxFQUFFO1lBQ2pCLE1BQU0sVUFBVSxHQUFHLElBQUksa0NBQXlCLENBQUMsR0FBVSxDQUFDLENBQUM7WUFDN0QsTUFBTSxNQUFNLEdBQUcsSUFBSSxvREFBMkIsQ0FDNUMsVUFBVSxFQUNWLFFBQW9CLENBQ3JCLENBQUM7WUFDRixNQUFNLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN2QyxDQUFDLENBQ0YsQ0FBQztJQUNKLENBQUMsQ0FBQyxDQUFDO0FBQ0wsQ0FBQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIENvcHlyaWdodCAoYykgSGFzaGlDb3JwLCBJbmMuXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTVBMLTIuMFxuICovXG5cbmltcG9ydCB7IExhbmd1YWdlLCBUZXJyYWZvcm1Nb2R1bGVDb25zdHJhaW50IH0gZnJvbSBcIi4vY29uZmlnXCI7XG5pbXBvcnQgeyBDb25zdHJ1Y3RzTWFrZXJNb2R1bGVUYXJnZXQgfSBmcm9tIFwiLi9jb25zdHJ1Y3QtbWFrZXItdGFyZ2V0XCI7XG5cbmRlc2NyaWJlKFwiQ29uc3RydWN0c01ha2VyTW9kdWxlVGFyZ2V0XCIsICgpID0+IHtcbiAgZGVzY3JpYmUuZWFjaChbXG4gICAge1xuICAgICAgZnFuOiBcImNsb3VkcG9zc2UvbGFiZWwvbnVsbFwiLFxuICAgICAgbmFtZXM6IHtcbiAgICAgICAgW0xhbmd1YWdlLlRZUEVTQ1JJUFRdOiBcImNsb3VkcG9zc2UubnVsbFwiLFxuICAgICAgICBbTGFuZ3VhZ2UuUFlUSE9OXTogXCJjbG91ZHBvc3NlLmxhYmVsLm51bGxcIixcbiAgICAgICAgW0xhbmd1YWdlLkpBVkFdOiBcImNsb3VkcG9zc2UubGFiZWwubnVsbFwiLFxuICAgICAgICBbTGFuZ3VhZ2UuQ1NIQVJQXTogXCJjbG91ZHBvc3NlLmxhYmVsLm51bGxcIixcbiAgICAgICAgW0xhbmd1YWdlLkdPXTogXCJsYWJlbFwiLFxuICAgICAgfSxcbiAgICB9LFxuICAgIHtcbiAgICAgIGZxbjogXCJ0ZXJyYWZvcm0tZ29vZ2xlLW1vZHVsZXMvcHJvamVjdC1mYWN0b3J5L2dvb2dsZVwiLFxuICAgICAgbmFtZXM6IHtcbiAgICAgICAgW0xhbmd1YWdlLlRZUEVTQ1JJUFRdOiBcInRlcnJhZm9ybV9nb29nbGVfbW9kdWxlcy5nb29nbGVcIixcbiAgICAgICAgW0xhbmd1YWdlLlBZVEhPTl06IFwidGVycmFmb3JtX2dvb2dsZV9tb2R1bGVzLnByb2plY3RfZmFjdG9yeS5nb29nbGVcIixcbiAgICAgICAgW0xhbmd1YWdlLkpBVkFdOiBcInRlcnJhZm9ybV9nb29nbGVfbW9kdWxlcy5wcm9qZWN0X2ZhY3RvcnkuZ29vZ2xlXCIsXG4gICAgICAgIFtMYW5ndWFnZS5DU0hBUlBdOiBcInRlcnJhZm9ybV9nb29nbGVfbW9kdWxlcy5wcm9qZWN0X2ZhY3RvcnkuZ29vZ2xlXCIsXG4gICAgICAgIFtMYW5ndWFnZS5HT106IFwicHJvamVjdF9mYWN0b3J5XCIsXG4gICAgICB9LFxuICAgIH0sXG4gICAge1xuICAgICAgZnFuOiBcInRlcnJhZm9ybS1hd3MtbW9kdWxlcy92cGMvYXdzQDUuMC4wXCIsXG4gICAgICBuYW1lczoge1xuICAgICAgICBbTGFuZ3VhZ2UuVFlQRVNDUklQVF06IFwidGVycmFmb3JtX2F3c19tb2R1bGVzLmF3c1wiLFxuICAgICAgICBbTGFuZ3VhZ2UuUFlUSE9OXTogXCJ0ZXJyYWZvcm1fYXdzX21vZHVsZXMudnBjLmF3c1wiLFxuICAgICAgICBbTGFuZ3VhZ2UuSkFWQV06IFwidGVycmFmb3JtX2F3c19tb2R1bGVzLnZwYy5hd3NcIixcbiAgICAgICAgW0xhbmd1YWdlLkNTSEFSUF06IFwidGVycmFmb3JtX2F3c19tb2R1bGVzLnZwYy5hd3NcIixcbiAgICAgICAgW0xhbmd1YWdlLkdPXTogXCJ2cGNcIixcbiAgICAgIH0sXG4gICAgfSxcbiAgICB7XG4gICAgICBmcW46IFwidGVycmFmb3JtLWF3cy1tb2R1bGVzL2Vrcy9hd3MvL21vZHVsZXMvc2VsZi1tYW5hZ2VkLW5vZGUtZ3JvdXBcIixcbiAgICAgIG5hbWVzOiB7XG4gICAgICAgIFtMYW5ndWFnZS5UWVBFU0NSSVBUXTogXCJ0ZXJyYWZvcm1fYXdzX21vZHVsZXMuYXdzLmVrcy5tb2R1bGVzXCIsXG4gICAgICAgIFtMYW5ndWFnZS5QWVRIT05dOlxuICAgICAgICAgIFwidGVycmFmb3JtX2F3c19tb2R1bGVzLmVrcy5hd3MubW9kdWxlcy5zZWxmX21hbmFnZWRfbm9kZV9ncm91cFwiLFxuICAgICAgICBbTGFuZ3VhZ2UuSkFWQV06XG4gICAgICAgICAgXCJ0ZXJyYWZvcm1fYXdzX21vZHVsZXMuZWtzLmF3cy5tb2R1bGVzLnNlbGZfbWFuYWdlZF9ub2RlX2dyb3VwXCIsXG4gICAgICAgIFtMYW5ndWFnZS5DU0hBUlBdOlxuICAgICAgICAgIFwidGVycmFmb3JtX2F3c19tb2R1bGVzLmVrcy5hd3MubW9kdWxlcy5zZWxmX21hbmFnZWRfbm9kZV9ncm91cFwiLFxuICAgICAgICBbTGFuZ3VhZ2UuR09dOiBcInNlbGZfbWFuYWdlZF9ub2RlX2dyb3VwXCIsXG4gICAgICB9LFxuICAgIH0sXG4gICAge1xuICAgICAgZnFuOiB7XG4gICAgICAgIG5hbWU6IFwibXktbG9jYWwtbW9kdWxlXCIsXG4gICAgICAgIHNvdXJjZTogXCIuL3BhdGgvdG8vbG9jYWwvdGVycmFmb3JtL21vZHVsZVwiLFxuICAgICAgfSxcbiAgICAgIG5hbWVzOiB7XG4gICAgICAgIFtMYW5ndWFnZS5UWVBFU0NSSVBUXTogXCJteS1sb2NhbC1tb2R1bGVcIixcbiAgICAgICAgW0xhbmd1YWdlLlBZVEhPTl06IFwibXlfbG9jYWxfbW9kdWxlXCIsXG4gICAgICAgIFtMYW5ndWFnZS5KQVZBXTogXCJteV9sb2NhbF9tb2R1bGVcIixcbiAgICAgICAgW0xhbmd1YWdlLkNTSEFSUF06IFwibXlfbG9jYWxfbW9kdWxlXCIsXG4gICAgICAgIFtMYW5ndWFnZS5HT106IFwibXlfbG9jYWxfbW9kdWxlXCIsXG4gICAgICB9LFxuICAgIH0sXG4gIF0pKFwiI3NyY01ha05hbWUgJSNcIiwgKHsgZnFuLCBuYW1lcyB9KSA9PiB7XG4gICAgaXQuZWFjaChPYmplY3QuZW50cmllcyhuYW1lcykpKFxuICAgICAgYGV4cGVjdCBuYW1lIGZvciAke0pTT04uc3RyaW5naWZ5KGZxbil9IGluICVzIHRvIGJlICVzYCxcbiAgICAgIChsYW5ndWFnZSwgbmFtZSkgPT4ge1xuICAgICAgICBjb25zdCBjb25zdHJhaW50ID0gbmV3IFRlcnJhZm9ybU1vZHVsZUNvbnN0cmFpbnQoZnFuIGFzIGFueSk7XG4gICAgICAgIGNvbnN0IHRhcmdldCA9IG5ldyBDb25zdHJ1Y3RzTWFrZXJNb2R1bGVUYXJnZXQoXG4gICAgICAgICAgY29uc3RyYWludCxcbiAgICAgICAgICBsYW5ndWFnZSBhcyBMYW5ndWFnZSxcbiAgICAgICAgKTtcbiAgICAgICAgZXhwZWN0KHRhcmdldC5zcmNNYWtOYW1lKS50b0JlKG5hbWUpO1xuICAgICAgfSxcbiAgICApO1xuICB9KTtcbn0pO1xuIl19