/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Language, TerraformDependencyConstraint } from "./config";
import { ModuleSchema } from "./module-schema";
import { ProviderSchema } from "./provider-schema";
export declare abstract class ConstructsMakerTarget {
    readonly constraint: TerraformDependencyConstraint;
    readonly targetLanguage: Language;
    readonly fileName: string;
    constructor(constraint: TerraformDependencyConstraint, targetLanguage: Language);
    static from(constraint: TerraformDependencyConstraint, targetLanguage: Language): ConstructsMakerModuleTarget | ConstructsMakerProviderTarget;
    get version(): string | undefined;
    get source(): string;
    get name(): string;
    get fqn(): string;
    get namespace(): string | undefined;
    get moduleKey(): string;
    abstract get srcMakName(): string;
    abstract get isModule(): boolean;
    abstract get isProvider(): boolean;
    abstract get trackingPayload(): Record<string, any>;
    protected abstract get simplifiedName(): string;
    protected abstract typesPath(name: string): string;
}
export declare class ConstructsMakerModuleTarget extends ConstructsMakerTarget {
    spec?: ModuleSchema;
    get isModule(): boolean;
    get isProvider(): boolean;
    get srcMakName(): string;
    get trackingPayload(): {
        name: string;
        fullName: string;
        version: string | undefined;
        type: string;
    };
    protected typesPath(name: string): string;
    protected get simplifiedName(): string;
    protected get simplifiedFqn(): string;
}
export declare class ConstructsMakerProviderTarget extends ConstructsMakerTarget {
    spec?: ProviderSchema;
    get isModule(): boolean;
    get isProvider(): boolean;
    get srcMakName(): string;
    get trackingPayload(): {
        name: string;
        fullName: string;
        version: string | undefined;
        type: string;
    };
    protected typesPath(name: string): string;
    private get isNullProvider();
    protected get simplifiedName(): string;
}
//# sourceMappingURL=construct-maker-target.d.ts.map