"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mkdtemp = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const config_1 = require("./config");
const fs = __importStar(require("fs-extra"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
async function mkdtemp(closure) {
    const workdir = await fs.mkdtemp(path.join(os.tmpdir(), "cdktf."));
    try {
        await closure(workdir);
    }
    finally {
        await fs.remove(workdir);
    }
}
exports.mkdtemp = mkdtemp;
describe("parseConfig", () => {
    it("provides default with no input", async () => {
        expect((0, config_1.parseConfig)()).toMatchInlineSnapshot(`
      {
        "codeMakerOutput": ".gen",
        "output": "cdktf.out",
      }
    `);
    });
    describe("providers", () => {
        it("parses provider string", async () => {
            const input = {
                terraformProviders: ["aws@~> 2.0"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformProviders": [
            TerraformProviderConstraint {
              "fqn": "aws",
              "name": "aws",
              "namespace": undefined,
              "source": "aws",
              "version": "~> 2.0",
            },
          ],
        }
      `);
        });
        it("parses provider string with namespace", async () => {
            const input = {
                terraformProviders: ["hashicorp/aws@~> 2.0"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformProviders": [
            TerraformProviderConstraint {
              "fqn": "hashicorp/aws",
              "name": "aws",
              "namespace": "hashicorp",
              "source": "hashicorp/aws",
              "version": "~> 2.0",
            },
          ],
        }
      `);
        });
        it("parses complex provider config", async () => {
            const input = {
                terraformProviders: [
                    {
                        name: "aws",
                        version: "~> 2.0",
                    },
                ],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformProviders": [
            TerraformProviderConstraint {
              "fqn": "aws",
              "name": "aws",
              "namespace": undefined,
              "source": undefined,
              "version": "~> 2.0",
            },
          ],
        }
      `);
        });
    });
    describe("modules", () => {
        it("parses module string", async () => {
            const input = {
                terraformModules: ["terraform-aws-modules/vpc/aws@2.39.0"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "terraform-aws-modules/vpc/aws",
              "name": "vpc",
              "namespace": "terraform-aws-modules/aws",
              "source": "terraform-aws-modules/vpc/aws",
              "version": "2.39.0",
            },
          ],
        }
      `);
        });
        it("parses module for local module for module generator", async () => {
            const input = {
                terraformModules: [
                    {
                        name: "local-module",
                        source: "./foo",
                    },
                ],
            };
            const parsed = (0, config_1.parseConfig)(JSON.stringify(input));
            expect(parsed.terraformModules[0].localSourceAbsolutePath).toMatch("/packages/@cdktf/commons/foo");
        });
        it("parses sub module registry string", async () => {
            const input = {
                terraformModules: [
                    "terraform-aws-modules/iam/aws//modules/iam-account@3.12.0",
                ],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "terraform-aws-modules/iam/aws/modules/iam-account",
              "name": "iam-account",
              "namespace": "terraform-aws-modules/aws/iam/modules",
              "source": "terraform-aws-modules/iam/aws//modules/iam-account",
              "version": "3.12.0",
            },
          ],
        }
      `);
        });
        it("takes complex config", async () => {
            const input = {
                terraformModules: [
                    {
                        name: "customAWSVpc",
                        source: "https://github.com/terraform-aws-modules/terraform-aws-vpc",
                        version: "~> v2.0",
                    },
                ],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "customAWSVpc",
              "name": "customAWSVpc",
              "namespace": undefined,
              "source": "https://github.com/terraform-aws-modules/terraform-aws-vpc",
              "version": "~> v2.0",
            },
          ],
        }
      `);
        });
        it("takes complex and string config", async () => {
            const input = {
                terraformModules: [
                    "terraform-aws-modules/vpc/aws@2.39.0",
                    {
                        name: "customAWSVpc",
                        source: "https://github.com/terraform-aws-modules/terraform-aws-vpc",
                        version: "~> v2.0",
                    },
                ],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "terraform-aws-modules/vpc/aws",
              "name": "vpc",
              "namespace": "terraform-aws-modules/aws",
              "source": "terraform-aws-modules/vpc/aws",
              "version": "2.39.0",
            },
            TerraformModuleConstraint {
              "fqn": "customAWSVpc",
              "name": "customAWSVpc",
              "namespace": undefined,
              "source": "https://github.com/terraform-aws-modules/terraform-aws-vpc",
              "version": "~> v2.0",
            },
          ],
        }
      `);
        });
        it("parses local path", async () => {
            const input = {
                terraformModules: ["./consul"],
            };
            const parsed = (0, config_1.parseConfig)(JSON.stringify(input));
            expect(parsed.terraformModules[0].localSourceAbsolutePath).toMatch("/packages/@cdktf/commons/consul");
            expect(parsed.terraformModules[0].name).toMatch("consul");
        });
        it("parses registry", async () => {
            const input = {
                terraformModules: ["hashicorp/consul/aws@0.1.0"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "hashicorp/consul/aws",
              "name": "consul",
              "namespace": "hashicorp/aws",
              "source": "hashicorp/consul/aws",
              "version": "0.1.0",
            },
          ],
        }
      `);
        });
        it("parses private registry", async () => {
            const input = {
                terraformModules: [
                    "app.terraform.io/example-corp/k8s-cluster/azurerm@1.1.0",
                ],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "app-terraform-io/example-corp/k8s-cluster/azurerm",
              "name": "k8s-cluster",
              "namespace": "example-corp/azurerm",
              "source": "app.terraform.io/example-corp/k8s-cluster/azurerm",
              "version": "1.1.0",
            },
          ],
        }
      `);
        });
        it("parses github", async () => {
            const input = {
                terraformModules: ["github.com/hashicorp/example"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "hashicorp/example",
              "name": "example",
              "namespace": "hashicorp",
              "source": "github.com/hashicorp/example",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses github ssh", async () => {
            const input = {
                terraformModules: ["git@github.com:hashicorp/example.git"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "hashicorp/example",
              "name": "example",
              "namespace": "hashicorp",
              "source": "git@github.com:hashicorp/example.git",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses bitbucket", async () => {
            const input = {
                terraformModules: ["bitbucket.org/hashicorp/terraform-consul-aws"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "hashicorp/terraform-consul-aws",
              "name": "terraform-consul-aws",
              "namespace": "hashicorp",
              "source": "bitbucket.org/hashicorp/terraform-consul-aws",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses generic git", async () => {
            const input = {
                terraformModules: ["git::https://example.com/vpc.git"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "vpc",
              "name": "vpc",
              "namespace": undefined,
              "source": "git::https://example.com/vpc.git",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses git ssh", async () => {
            const input = {
                terraformModules: ["git::ssh://username@example.com/storage.git"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "storage",
              "name": "storage",
              "namespace": undefined,
              "source": "git::ssh://username@example.com/storage.git",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses revision", async () => {
            const input = {
                terraformModules: [
                    "git::https://example.com/infra/main-vpc.git?ref=v1.2.0",
                ],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "infra/main-vpc",
              "name": "main-vpc",
              "namespace": "infra",
              "source": "git::https://example.com/infra/main-vpc.git?ref=v1.2.0",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses scp", async () => {
            const input = {
                terraformModules: ["git::username@example.com:storage.git"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "storage",
              "name": "storage",
              "namespace": undefined,
              "source": "git::username@example.com:storage.git",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses mercurial", async () => {
            const input = {
                terraformModules: ["hg::http://example.com/vpc.hg"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "vpc",
              "name": "vpc",
              "namespace": undefined,
              "source": "hg::http://example.com/vpc.hg",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses hg revision", async () => {
            const input = {
                terraformModules: ["hg::http://example.com/vpc.hg?ref=v1.2.0"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "vpc",
              "name": "vpc",
              "namespace": undefined,
              "source": "hg::http://example.com/vpc.hg?ref=v1.2.0",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses http", async () => {
            const input = {
                terraformModules: ["https://example.com/vpc-module.zip"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "vpc-module",
              "name": "vpc-module",
              "namespace": undefined,
              "source": "https://example.com/vpc-module.zip",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses archive type", async () => {
            const input = {
                terraformModules: ["https://example.com/vpc-module?archive=zip"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "vpc-module",
              "name": "vpc-module",
              "namespace": undefined,
              "source": "https://example.com/vpc-module?archive=zip",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses s3", async () => {
            const input = {
                terraformModules: [
                    "s3::https://s3-eu-west-1.amazonaws.com/examplecorp-terraform-modules/vpc.zip",
                ],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "examplecorp-terraform-modules/vpc",
              "name": "vpc",
              "namespace": "examplecorp-terraform-modules",
              "source": "s3::https://s3-eu-west-1.amazonaws.com/examplecorp-terraform-modules/vpc.zip",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses gcs", async () => {
            const input = {
                terraformModules: [
                    "gcs::https://www.googleapis.com/storage/v1/modules/foomodule.zip",
                ],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "storage/v1/modules/foomodule",
              "name": "foomodule",
              "namespace": "modules",
              "source": "gcs::https://www.googleapis.com/storage/v1/modules/foomodule.zip",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses submodule registry", async () => {
            const input = {
                terraformModules: ["hashicorp/consul/aws//modules/consul-cluster"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "hashicorp/consul/aws/modules/consul-cluster",
              "name": "consul-cluster",
              "namespace": "hashicorp/aws/consul/modules",
              "source": "hashicorp/consul/aws//modules/consul-cluster",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses submodule git", async () => {
            const input = {
                terraformModules: ["git::https://example.com/network.git//modules/vpc"],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "network/modules/vpc",
              "name": "vpc",
              "namespace": "network/modules",
              "source": "git::https://example.com/network.git//modules/vpc",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses submodule http", async () => {
            const input = {
                terraformModules: [
                    "https://example.com/network-module.zip//modules/vpc",
                ],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "network-module/modules/vpc",
              "name": "vpc",
              "namespace": "network-module/modules",
              "source": "https://example.com/network-module.zip//modules/vpc",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses submodule s3", async () => {
            const input = {
                terraformModules: [
                    "s3::https://s3-eu-west-1.amazonaws.com/examplecorp-terraform-modules/network.zip//modules/vpc",
                ],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "examplecorp-terraform-modules/network/modules/vpc",
              "name": "vpc",
              "namespace": "examplecorp-terraform-modules/network/modules",
              "source": "s3::https://s3-eu-west-1.amazonaws.com/examplecorp-terraform-modules/network.zip//modules/vpc",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses submodule ref", async () => {
            const input = {
                terraformModules: [
                    "git::https://example.com/network.git//modules/vpc?ref=v1.2.0",
                ],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "network/modules/vpc",
              "name": "vpc",
              "namespace": "network/modules",
              "source": "git::https://example.com/network.git//modules/vpc?ref=v1.2.0",
              "version": undefined,
            },
          ],
        }
      `);
        });
        it("parses ref with /", async () => {
            const input = {
                terraformModules: [
                    "git::https://github.com/cloudposse/terraform-null-label.git?ref=tags/0.14.1",
                ],
            };
            expect((0, config_1.parseConfig)(JSON.stringify(input))).toMatchInlineSnapshot(`
        {
          "codeMakerOutput": ".gen",
          "output": "cdktf.out",
          "terraformModules": [
            TerraformModuleConstraint {
              "fqn": "cloudposse/terraform-null-label",
              "name": "terraform-null-label",
              "namespace": "cloudposse",
              "source": "git::https://github.com/cloudposse/terraform-null-label.git?ref=tags/0.14.1",
              "version": undefined,
            },
          ],
        }
      `);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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