"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.logTimespan = exports.shouldCheckCodeMakerOutput = exports.readConfigSync = exports.parseConfig = exports.TerraformProviderConstraint = exports.TerraformModuleConstraint = exports.isLocalModule = exports.CONFIG_DEFAULTS = exports.LANGUAGES = exports.Language = void 0;
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
const logging_1 = require("./logging");
const terraform_module_1 = require("./terraform-module");
const process_1 = require("process");
const codemaker_1 = require("codemaker");
var Language;
(function (Language) {
    Language["TYPESCRIPT"] = "typescript";
    Language["PYTHON"] = "python";
    Language["CSHARP"] = "csharp";
    Language["JAVA"] = "java";
    Language["GO"] = "go";
})(Language || (exports.Language = Language = {}));
exports.LANGUAGES = [
    Language.TYPESCRIPT,
    Language.PYTHON,
    Language.JAVA,
    Language.CSHARP,
    Language.GO,
];
const CONTEXT_ENV = "CDKTF_CONTEXT_JSON";
const CONFIG_FILE = "cdktf.json";
exports.CONFIG_DEFAULTS = {
    output: "cdktf.out",
    codeMakerOutput: ".gen",
};
function isPresent(input) {
    return Array.isArray(input) && input.length > 0;
}
function getLocalMatch(source) {
    return source.match(/^(\.\/|\.\.\/|\.\\\\|\.\.\\\\)(.*)/);
}
function isLocalModule(source) {
    return getLocalMatch(source) !== null;
}
exports.isLocalModule = isLocalModule;
class TerraformModuleConstraint {
    constructor(item) {
        if (typeof item === "string") {
            const parsed = this.parseDependencyConstraint(item);
            this.name = parsed.name;
            this.source = parsed.source;
            this.fqn = parsed.fqn;
            this.version = parsed.version;
            this.namespace = parsed.namespace;
        }
        else {
            this.source = item.source;
            this.name = item.name;
            this.fqn = item.name;
            this.version = item.version;
            this.namespace = item.namespace;
        }
        const localMatch = getLocalMatch(this.source);
        if (localMatch) {
            this.localSourceAbsolutePath = path.join(process.cwd(), this.source);
        }
    }
    get className() {
        return (0, codemaker_1.toPascalCase)(this.name.replace(/[-/.]/g, "_"));
    }
    get fileName() {
        return this.namespace ? `${this.namespace}/${this.name}` : this.name;
    }
    parseDependencyConstraint(item) {
        var _a, _b, _c;
        const localMatch = getLocalMatch(item);
        if (localMatch) {
            const fqn = localMatch[2];
            const nameParts = fqn.split("/");
            const name = (_a = nameParts.pop()) !== null && _a !== void 0 ? _a : fqn;
            const namespace = nameParts.pop();
            return {
                name,
                fqn,
                source: item,
                namespace,
            };
        }
        const [source, version] = item.split("@");
        let moduleParts = source.split("//");
        if ((0, terraform_module_1.isRegistryModule)(moduleParts[0])) {
            const nameParts = moduleParts[0].split("/");
            const provider = nameParts.pop(); // last part is the provider
            let name = (_b = nameParts.pop()) !== null && _b !== void 0 ? _b : source;
            let namespace = `${nameParts.pop()}/${provider}`;
            if (moduleParts.length > 1) {
                const moduleNameParts = moduleParts[1].split("/");
                const moduleName = moduleNameParts.pop();
                namespace = `${namespace}/${name}/${moduleNameParts.join("/")}`;
                name = moduleName !== null && moduleName !== void 0 ? moduleName : name;
            }
            return {
                name,
                source,
                version,
                namespace,
                fqn: source.replace("//", "/").replace(/\./g, "-"),
            };
        }
        let toProcess = item; // process one part at a time
        // strip off any prefix
        const prefixMatch = toProcess.match(/^([a-zA-Z0-9]*)::(.*)/);
        if (prefixMatch) {
            toProcess = prefixMatch[2];
        }
        // strip off any protocol
        const protocolMatch = toProcess.match(/^([a-zA-Z]*):\/\/(.*)/);
        if (protocolMatch) {
            toProcess = protocolMatch[2];
        }
        // anything before last ':' won't contribute
        const colonParts = toProcess.split(":");
        toProcess = (_c = colonParts.pop()) !== null && _c !== void 0 ? _c : toProcess;
        // strip off any port
        const portMatch = toProcess.match(/^[\d]*(.*)/);
        if (portMatch) {
            toProcess = portMatch[1];
        }
        // strip off any hostname
        const hostMatch = toProcess.match(/[^/]*\.[^/]*\/(.*)/);
        if (hostMatch) {
            toProcess = hostMatch[1];
        }
        // strip off any arguments
        const argumentMatch = toProcess.match(/(.*)\?.*/);
        if (argumentMatch) {
            toProcess = argumentMatch[1];
        }
        // strip off any types
        toProcess = toProcess.replace(/\.git|\.hg|\.zip/, "");
        moduleParts = toProcess.split("//");
        const nameParts = moduleParts[0].split("/");
        let name = nameParts.pop();
        let namespace = nameParts.pop();
        if (!name) {
            throw new Error(`Module name should be properly set in ${item}`);
        }
        if (moduleParts.length > 1) {
            const moduleNameParts = moduleParts[1].split("/");
            const moduleName = moduleNameParts.pop();
            if (namespace) {
                namespace = `${namespace}/${name}/${moduleNameParts.join("/")}`;
            }
            else {
                namespace = `${name}/${moduleNameParts.join("/")}`;
            }
            name = moduleName !== null && moduleName !== void 0 ? moduleName : name;
        }
        return {
            name,
            source: item,
            fqn: toProcess.replace("//", "/"),
            namespace,
        };
    }
}
exports.TerraformModuleConstraint = TerraformModuleConstraint;
class TerraformProviderConstraint {
    constructor(item) {
        if (typeof item === "string") {
            const parsed = this.parseDependencyConstraint(item);
            this.name = parsed.name;
            this.fqn = parsed.fqn;
            this.source = parsed.fqn;
            this.version = parsed.version;
            this.namespace = parsed.namespace;
        }
        else {
            this.name = item.name;
            this.fqn = item.name;
            this.version = item.version;
            this.source = item.source;
            this.namespace = item.namespace;
        }
    }
    parseDependencyConstraint(item) {
        const [fqn, version] = item.split("@");
        const nameParts = fqn.split("/");
        const name = nameParts.pop();
        const namespace = nameParts.pop();
        if (!name) {
            throw new Error(`Provider name should be properly set in ${item}`);
        }
        return {
            name,
            source: fqn,
            // Terraform doesn't support *, instead no version is specified
            version: version === "*" ? undefined : version,
            fqn,
            namespace,
        };
    }
}
exports.TerraformProviderConstraint = TerraformProviderConstraint;
const parseConfig = (configJSON) => {
    var _a, _b;
    const config = {
        ...exports.CONFIG_DEFAULTS,
        ...JSON.parse(configJSON || "{}"),
    };
    if (isPresent(config.terraformModules)) {
        config.terraformModules = (_a = config.terraformModules) === null || _a === void 0 ? void 0 : _a.map((mod) => new TerraformModuleConstraint(mod));
    }
    if (isPresent(config.terraformProviders)) {
        config.terraformProviders = (_b = config.terraformProviders) === null || _b === void 0 ? void 0 : _b.map((provider) => new TerraformProviderConstraint(provider));
    }
    if (config.context) {
        process_1.env[CONTEXT_ENV] = JSON.stringify(config.context);
    }
    return config;
};
exports.parseConfig = parseConfig;
function readConfigSync(configFile = path.join(process.cwd(), CONFIG_FILE)) {
    let configFileContent;
    if (fs.existsSync(configFile)) {
        configFileContent = fs.readFileSync(configFile).toString();
    }
    return (0, exports.parseConfig)(configFileContent);
}
exports.readConfigSync = readConfigSync;
function shouldCheckCodeMakerOutput(config) {
    return (isPresent(config.terraformModules) || isPresent(config.terraformProviders));
}
exports.shouldCheckCodeMakerOutput = shouldCheckCodeMakerOutput;
function logTimespan(message) {
    logging_1.logger.debug(`Start timer for ${message}...`);
    const start = Date.now();
    return function logTimespanEnd() {
        const end = Date.now();
        const duration = end - start;
        logging_1.logger.debug(`${message} took ${duration}ms`);
    };
}
exports.logTimespan = logTimespan;
//# sourceMappingURL=data:application/json;base64,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