/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
export declare enum Language {
    TYPESCRIPT = "typescript",
    PYTHON = "python",
    CSHARP = "csharp",
    JAVA = "java",
    GO = "go"
}
export declare const LANGUAGES: Language[];
export declare const CONFIG_DEFAULTS: {
    output: string;
    codeMakerOutput: string;
};
export interface TerraformDependencyConstraint {
    readonly name: string;
    readonly source: string;
    readonly version?: string;
    readonly fqn: string;
    readonly namespace?: string;
}
export declare function isLocalModule(source: string): boolean;
export declare class TerraformModuleConstraint implements TerraformDependencyConstraint {
    readonly name: string;
    readonly source: string;
    readonly localSourceAbsolutePath?: string;
    readonly fqn: string;
    readonly version?: string;
    readonly namespace?: string;
    constructor(item: TerraformDependencyConstraint | string);
    get className(): string;
    get fileName(): string;
    private parseDependencyConstraint;
}
export declare class TerraformProviderConstraint implements TerraformDependencyConstraint {
    readonly name: string;
    readonly source: string;
    readonly version?: string;
    readonly fqn: string;
    readonly namespace?: string;
    constructor(item: Omit<TerraformDependencyConstraint, "fqn"> | string);
    private parseDependencyConstraint;
}
export interface Config {
    readonly app?: string;
    readonly language?: Language;
    readonly output: string;
    readonly codeMakerOutput: string;
    terraformProviders?: TerraformProviderConstraint[];
    terraformModules?: TerraformModuleConstraint[];
    readonly context?: {
        [key: string]: any;
    };
}
export declare const parseConfig: (configJSON?: string) => Config;
export declare function readConfigSync(configFile?: string): Config;
export declare function shouldCheckCodeMakerOutput(config: Config): boolean;
export declare function logTimespan(message: string): () => void;
//# sourceMappingURL=config.d.ts.map