"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReportRequest = exports.getUserId = exports.getProjectId = exports.sendTelemetry = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const https = require("https");
const url_1 = require("url");
const uuid_1 = require("uuid");
const os = __importStar(require("os"));
const ci_info_1 = __importDefault(require("ci-info"));
const logging_1 = require("./logging");
const path = __importStar(require("path"));
const fs = __importStar(require("fs-extra"));
const version_1 = require("./version");
const environment_1 = require("./environment");
const BASE_URL = `https://checkpoint-api.hashicorp.com/v1/`;
const VALID_STATUS_CODES = [200, 201];
const MAX_REQUEST_BODY_SIZE = 8192;
function homeDir() {
    var _a;
    return process.env.CDKTF_HOME
        ? path.resolve(process.env.CDKTF_HOME)
        : path.join(((_a = os.userInfo().homedir) !== null && _a !== void 0 ? _a : os.homedir()).trim() || "/", ".cdktf");
}
async function post(url, data) {
    return new Promise((ok, ko) => {
        const req = https.request((0, url_1.format)(url), {
            headers: {
                Accept: "application/json",
                "Content-Length": data.length,
                "User-Agent": "HashiCorp/cdktf-cli",
            },
            method: "POST",
        }, (res) => {
            if (res.statusCode) {
                const statusCode = res.statusCode;
                if (!VALID_STATUS_CODES.includes(statusCode)) {
                    return ko(new Error(res.statusMessage));
                }
            }
            const data = new Array();
            res.on("data", (chunk) => data.push(chunk));
            res.on("error", (err) => ko(err));
            res.on("end", () => {
                return ok();
            });
        });
        req.setTimeout(1000, () => ko(new Error("request timeout")));
        req.write(data);
        req.end();
        req.on("error", (err) => ko(err));
    });
}
async function sendTelemetry(command, payload) {
    const reportParams = {
        command,
        product: "cdktf",
        version: `${version_1.DISPLAY_VERSION}`,
        dateTime: new Date(),
        language: payload.language,
        payload,
    };
    try {
        await ReportRequest(reportParams);
    }
    catch (err) {
        logging_1.logger.error(`Could not send telemetry data: ${err}`);
    }
}
exports.sendTelemetry = sendTelemetry;
function getId(filePath, key, forceCreation = false, explanatoryComment) {
    const _uuid = (0, uuid_1.v4)(); // create a new UUID in case we don't find one
    let jsonFile;
    try {
        jsonFile = require(filePath); // we found the file
    }
    catch (_a) {
        // we found no file, create one if we're forcing a creation
        if (forceCreation) {
            const _idFile = {}; // compose JSON id file in case we don't find one
            if (explanatoryComment) {
                _idFile["//"] = explanatoryComment.replace(/\n/g, " ");
            }
            _idFile[key] = _uuid;
            fs.ensureDirSync(path.dirname(filePath));
            fs.writeFileSync(filePath, JSON.stringify(_idFile, null, 2));
        }
        return _uuid;
    }
    if (jsonFile[key]) {
        return jsonFile[key]; // we found an id
    }
    else {
        // we found no id, we add it to the file for future use
        fs.writeFileSync(filePath, JSON.stringify({ ...jsonFile, [key]: _uuid }, null, 2));
        return _uuid;
    }
}
function getProjectId(projectPath = process.cwd()) {
    return getId(path.resolve(projectPath, "cdktf.json"), "projectId");
}
exports.getProjectId = getProjectId;
function getUserId() {
    return getId(path.resolve(homeDir(), "config.json"), "userId", true, `This signature is a randomly generated UUID used to anonymously differentiate users in telemetry data order to inform product direction.
This signature is random, it is not based on any personally identifiable information.
To create a new signature, you can simply delete this file at any time.
See https://cdk.tf/telemetry for more
information on how to disable it.`);
}
exports.getUserId = getUserId;
async function ReportRequest(reportParams) {
    // we won't report when checkpoint is disabled.
    if (environment_1.CHECKPOINT_DISABLE) {
        return;
    }
    if (!reportParams.runID) {
        reportParams.runID = (0, uuid_1.v4)();
    }
    if (!reportParams.dateTime) {
        reportParams.dateTime = new Date();
    }
    if (!reportParams.arch) {
        reportParams.arch = os.arch();
    }
    if (!reportParams.os) {
        reportParams.os = os.platform();
    }
    const ci = ci_info_1.default.isCI ? ci_info_1.default.name || "unknown" : false;
    if (!reportParams.userId && !ci) {
        reportParams.userId = getUserId();
    }
    if (ci) {
        reportParams.ci = ci;
    }
    reportParams.projectId = reportParams.projectId || getProjectId();
    const postData = JSON.stringify(reportParams);
    if (postData.length > MAX_REQUEST_BODY_SIZE) {
        logging_1.logger.warn(`Skipped sending telemetry as the request body size was ${postData.length} bytes. The limit is ${MAX_REQUEST_BODY_SIZE} bytes`);
        return;
    }
    try {
        await post(`${BASE_URL}telemetry/${reportParams.product}`, postData);
    }
    catch (e) {
        // Log errors writing to checkpoint
        (0, logging_1.processLoggerError)(e.message);
    }
}
exports.ReportRequest = ReportRequest;
//# sourceMappingURL=data:application/json;base64,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