"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.watch = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const path_1 = __importDefault(require("path"));
const cdktf_project_1 = require("./cdktf-project");
const fs = __importStar(require("fs"));
const chokidar = __importStar(require("chokidar"));
const commons_1 = require("@cdktf/commons");
// In this very first iteration we will find out which files to watch by asking the user to provide the files
// We default to something reasonable per language and write it into the cdkt.json file
// Mid-Term we might want to add a WatchFile / WatchDir construct that we can use (e.g. in assets) and that a user can use to specify their watch behaviour
// See https://github.com/hashicorp/terraform-cdk/issues/1668
function getOrWriteDefaultWatchConfig(projectPath = process.cwd()) {
    const cdktfJsonPath = path_1.default.resolve(projectPath, "cdktf.json");
    commons_1.logger.debug(`Getting files to watch from cdktf.json at ${cdktfJsonPath}`);
    let cdktfJson;
    try {
        cdktfJson = require(cdktfJsonPath);
    }
    catch (err) {
        throw commons_1.Errors.Internal(`Could not find cdktf.json file in ${projectPath}`, err);
    }
    if (cdktfJson.watchPattern) {
        commons_1.logger.debug(`Found watchPattern in cdktf.json: ${cdktfJson.watchPattern}`);
        return cdktfJson.watchPattern;
    }
    const language = cdktfJson.language;
    if (!language) {
        throw commons_1.Errors.Usage(`No language specified in cdktf.json, please either specify a language or watchPattern to use the watch command`);
    }
    const defaultWatchPattern = {
        typescript: ["./**/*.ts"],
        python: ["./**/*.py"],
        java: ["src/**/*.java"],
        csharp: ["./**/*.cs"],
        go: ["./**/*.go"],
    }[language];
    fs.writeFileSync(cdktfJsonPath, JSON.stringify({ ...cdktfJson, watchPattern: defaultWatchPattern }, null, 2));
    commons_1.logger.debug(`Write default watchPattern for ${language} in cdktf.json.`);
    return defaultWatchPattern;
}
const projectStatus = (project) => {
    if (!(project === null || project === void 0 ? void 0 : project.stacksToRun.length)) {
        return {
            inProgress: [],
            finished: [],
            pending: [],
        };
    }
    const inProgress = project.stacksToRun.filter((s) => s.isRunning);
    const finished = project.stacksToRun.filter((s) => s.isDone);
    const pending = project.stacksToRun.filter((s) => s.isPending);
    return { inProgress, finished, pending };
};
async function watch(projectOptions, mutationOptions, abortSignal, onStateChange) {
    const patterns = getOrWriteDefaultWatchConfig();
    const watcher = chokidar.watch(patterns, {
        ignoreInitial: true,
    });
    let state = { type: "waiting" };
    const changeState = (newState) => {
        state = newState;
        onStateChange(state);
    };
    async function run() {
        commons_1.logger.debug("Running cdktf deploy");
        const project = new cdktf_project_1.CdktfProject({
            synthOrigin: "watch",
            ...projectOptions,
            onLog: (log) => {
                if (projectOptions.onLog) {
                    projectOptions.onLog(log);
                }
                if (state.type === "running") {
                    changeState({ ...state, ...projectStatus(project) });
                }
            },
        });
        const abort = () => project.hardAbort();
        abortSignal.addEventListener("abort", abort);
        await project.deploy(mutationOptions);
        abortSignal.removeEventListener("abort", abort);
        commons_1.logger.debug("cdktf deploy finished");
        if (state.type !== "running") {
            throw commons_1.Errors.Internal("Watch was in a state where the state was not running in the run phase");
        }
        if (state.nextRunQueued) {
            commons_1.logger.debug("Next run was queued, starting it now");
            changeState({
                ...state,
                nextRunQueued: false,
                currentRun: run(),
                ...projectStatus(project),
            });
        }
        else {
            commons_1.logger.debug("Nothing queued, waiting for changes");
            changeState({ type: "waiting" });
        }
    }
    abortSignal.addEventListener("abort", () => {
        commons_1.logger.debug("Abort signal received, stopping watch");
        watcher.close();
        changeState({ type: "stopped" });
    });
    const onFileChange = () => {
        if (state.type === "stopped") {
            return;
        }
        if (state.type === "running") {
            changeState({ ...state, nextRunQueued: true });
            return;
        }
        changeState({
            type: "running",
            nextRunQueued: false,
            currentRun: run(),
            ...projectStatus(),
        });
    };
    watcher.on("all", onFileChange);
    // initially run once
    onFileChange();
    await (0, commons_1.sendTelemetry)("watch", { event: "start" });
}
exports.watch = watch;
//# sourceMappingURL=data:application/json;base64,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