/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { ProviderConstraint } from "./dependencies/dependency-manager";
type TerraformProviderLockFileEntry = {
    name: string;
    version?: string;
    constraints?: ProviderConstraint;
};
export declare class TerraformProviderLock {
    private stackWorkingDirectory;
    private _providerLockData;
    constructor(stackWorkingDirectory: string);
    private get lockFilePath();
    hasProviderLockFile(): Promise<boolean>;
    private readProviderLockFile;
    private parseProviderLockFile;
    providers(forceReread?: boolean): Promise<{
        [name: string]: TerraformProviderLockFileEntry;
    }>;
    hasMatchingProvider(constraint: ProviderConstraint): Promise<boolean | undefined>;
}
export {};
//# sourceMappingURL=terraform-provider-lock.d.ts.map