"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.printAnnotations = void 0;
const cdktf_1 = require("cdktf");
const chalk = __importStar(require("chalk"));
const chalkColour = new chalk.Instance();
/**
 * prints annotations via console
 * @throws Error if an Annotation with level === ERROR has been encountered
 */
function printAnnotations(stacks) {
    let encounteredAnnotationError = false;
    stacks.forEach((stack) => (stack.annotations || []).forEach((annotation) => {
        if (annotation.level === cdktf_1.AnnotationMetadataEntryType.ERROR)
            encounteredAnnotationError = true;
        let color = chalkColour.whiteBright;
        let level = annotation.level;
        switch (annotation.level) {
            case cdktf_1.AnnotationMetadataEntryType.INFO: {
                level = "INFO";
                break;
            }
            case cdktf_1.AnnotationMetadataEntryType.WARN: {
                color = chalkColour.hex("#FFA500"); // orange
                level = "WARN";
                break;
            }
            case cdktf_1.AnnotationMetadataEntryType.ERROR: {
                color = chalkColour.redBright;
                level = "ERROR";
                break;
            }
        }
        console.log(color(`${level} [${annotation.constructPath}]: ${annotation.message}`));
        if (annotation.level === cdktf_1.AnnotationMetadataEntryType.ERROR &&
            annotation.stacktrace)
            console.log(chalkColour.gray(annotation.stacktrace.join("\n")));
    }));
    if (encounteredAnnotationError) {
        throw new Error("While synthesizing one or more error annotations have been encountered. Please check the log output above.");
    }
}
exports.printAnnotations = printAnnotations;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3ludGguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzeW50aC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQUdBLGlDQUFvRDtBQUNwRCw2Q0FBK0I7QUFFL0IsTUFBTSxXQUFXLEdBQUcsSUFBSSxLQUFLLENBQUMsUUFBUSxFQUFFLENBQUM7QUFFekM7OztHQUdHO0FBQ0gsU0FBZ0IsZ0JBQWdCLENBQUMsTUFBMEI7SUFDekQsSUFBSSwwQkFBMEIsR0FBRyxLQUFLLENBQUM7SUFFdkMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQ3ZCLENBQUMsS0FBSyxDQUFDLFdBQVcsSUFBSSxFQUFFLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxVQUFVLEVBQUUsRUFBRTtRQUMvQyxJQUFJLFVBQVUsQ0FBQyxLQUFLLEtBQUssbUNBQTJCLENBQUMsS0FBSztZQUN4RCwwQkFBMEIsR0FBRyxJQUFJLENBQUM7UUFFcEMsSUFBSSxLQUFLLEdBQUcsV0FBVyxDQUFDLFdBQVcsQ0FBQztRQUNwQyxJQUFJLEtBQUssR0FBVyxVQUFVLENBQUMsS0FBSyxDQUFDO1FBQ3JDLFFBQVEsVUFBVSxDQUFDLEtBQUssRUFBRTtZQUN4QixLQUFLLG1DQUEyQixDQUFDLElBQUksQ0FBQyxDQUFDO2dCQUNyQyxLQUFLLEdBQUcsTUFBTSxDQUFDO2dCQUNmLE1BQU07YUFDUDtZQUNELEtBQUssbUNBQTJCLENBQUMsSUFBSSxDQUFDLENBQUM7Z0JBQ3JDLEtBQUssR0FBRyxXQUFXLENBQUMsR0FBRyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsU0FBUztnQkFDN0MsS0FBSyxHQUFHLE1BQU0sQ0FBQztnQkFDZixNQUFNO2FBQ1A7WUFDRCxLQUFLLG1DQUEyQixDQUFDLEtBQUssQ0FBQyxDQUFDO2dCQUN0QyxLQUFLLEdBQUcsV0FBVyxDQUFDLFNBQVMsQ0FBQztnQkFDOUIsS0FBSyxHQUFHLE9BQU8sQ0FBQztnQkFDaEIsTUFBTTthQUNQO1NBQ0Y7UUFDRCxPQUFPLENBQUMsR0FBRyxDQUNULEtBQUssQ0FBQyxHQUFHLEtBQUssS0FBSyxVQUFVLENBQUMsYUFBYSxNQUFNLFVBQVUsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUN2RSxDQUFDO1FBQ0YsSUFDRSxVQUFVLENBQUMsS0FBSyxLQUFLLG1DQUEyQixDQUFDLEtBQUs7WUFDdEQsVUFBVSxDQUFDLFVBQVU7WUFFckIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNwRSxDQUFDLENBQUMsQ0FDSCxDQUFDO0lBRUYsSUFBSSwwQkFBMEIsRUFBRTtRQUM5QixNQUFNLElBQUksS0FBSyxDQUNiLDRHQUE0RyxDQUM3RyxDQUFDO0tBQ0g7QUFDSCxDQUFDO0FBMUNELDRDQTBDQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAoYykgSGFzaGlDb3JwLCBJbmNcbi8vIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBNUEwtMi4wXG5pbXBvcnQgeyBTeW50aGVzaXplZFN0YWNrIH0gZnJvbSBcIi4vc3ludGgtc3RhY2tcIjtcbmltcG9ydCB7IEFubm90YXRpb25NZXRhZGF0YUVudHJ5VHlwZSB9IGZyb20gXCJjZGt0ZlwiO1xuaW1wb3J0ICogYXMgY2hhbGsgZnJvbSBcImNoYWxrXCI7XG5cbmNvbnN0IGNoYWxrQ29sb3VyID0gbmV3IGNoYWxrLkluc3RhbmNlKCk7XG5cbi8qKlxuICogcHJpbnRzIGFubm90YXRpb25zIHZpYSBjb25zb2xlXG4gKiBAdGhyb3dzIEVycm9yIGlmIGFuIEFubm90YXRpb24gd2l0aCBsZXZlbCA9PT0gRVJST1IgaGFzIGJlZW4gZW5jb3VudGVyZWRcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHByaW50QW5ub3RhdGlvbnMoc3RhY2tzOiBTeW50aGVzaXplZFN0YWNrW10pIHtcbiAgbGV0IGVuY291bnRlcmVkQW5ub3RhdGlvbkVycm9yID0gZmFsc2U7XG5cbiAgc3RhY2tzLmZvckVhY2goKHN0YWNrKSA9PlxuICAgIChzdGFjay5hbm5vdGF0aW9ucyB8fCBbXSkuZm9yRWFjaCgoYW5ub3RhdGlvbikgPT4ge1xuICAgICAgaWYgKGFubm90YXRpb24ubGV2ZWwgPT09IEFubm90YXRpb25NZXRhZGF0YUVudHJ5VHlwZS5FUlJPUilcbiAgICAgICAgZW5jb3VudGVyZWRBbm5vdGF0aW9uRXJyb3IgPSB0cnVlO1xuXG4gICAgICBsZXQgY29sb3IgPSBjaGFsa0NvbG91ci53aGl0ZUJyaWdodDtcbiAgICAgIGxldCBsZXZlbDogc3RyaW5nID0gYW5ub3RhdGlvbi5sZXZlbDtcbiAgICAgIHN3aXRjaCAoYW5ub3RhdGlvbi5sZXZlbCkge1xuICAgICAgICBjYXNlIEFubm90YXRpb25NZXRhZGF0YUVudHJ5VHlwZS5JTkZPOiB7XG4gICAgICAgICAgbGV2ZWwgPSBcIklORk9cIjtcbiAgICAgICAgICBicmVhaztcbiAgICAgICAgfVxuICAgICAgICBjYXNlIEFubm90YXRpb25NZXRhZGF0YUVudHJ5VHlwZS5XQVJOOiB7XG4gICAgICAgICAgY29sb3IgPSBjaGFsa0NvbG91ci5oZXgoXCIjRkZBNTAwXCIpOyAvLyBvcmFuZ2VcbiAgICAgICAgICBsZXZlbCA9IFwiV0FSTlwiO1xuICAgICAgICAgIGJyZWFrO1xuICAgICAgICB9XG4gICAgICAgIGNhc2UgQW5ub3RhdGlvbk1ldGFkYXRhRW50cnlUeXBlLkVSUk9SOiB7XG4gICAgICAgICAgY29sb3IgPSBjaGFsa0NvbG91ci5yZWRCcmlnaHQ7XG4gICAgICAgICAgbGV2ZWwgPSBcIkVSUk9SXCI7XG4gICAgICAgICAgYnJlYWs7XG4gICAgICAgIH1cbiAgICAgIH1cbiAgICAgIGNvbnNvbGUubG9nKFxuICAgICAgICBjb2xvcihgJHtsZXZlbH0gWyR7YW5ub3RhdGlvbi5jb25zdHJ1Y3RQYXRofV06ICR7YW5ub3RhdGlvbi5tZXNzYWdlfWApLFxuICAgICAgKTtcbiAgICAgIGlmIChcbiAgICAgICAgYW5ub3RhdGlvbi5sZXZlbCA9PT0gQW5ub3RhdGlvbk1ldGFkYXRhRW50cnlUeXBlLkVSUk9SICYmXG4gICAgICAgIGFubm90YXRpb24uc3RhY2t0cmFjZVxuICAgICAgKVxuICAgICAgICBjb25zb2xlLmxvZyhjaGFsa0NvbG91ci5ncmF5KGFubm90YXRpb24uc3RhY2t0cmFjZS5qb2luKFwiXFxuXCIpKSk7XG4gICAgfSksXG4gICk7XG5cbiAgaWYgKGVuY291bnRlcmVkQW5ub3RhdGlvbkVycm9yKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgXCJXaGlsZSBzeW50aGVzaXppbmcgb25lIG9yIG1vcmUgZXJyb3IgYW5ub3RhdGlvbnMgaGF2ZSBiZWVuIGVuY291bnRlcmVkLiBQbGVhc2UgY2hlY2sgdGhlIGxvZyBvdXRwdXQgYWJvdmUuXCIsXG4gICAgKTtcbiAgfVxufVxuIl19