import { StackManifest, TerraformStackMetadata } from "cdktf";
export interface SynthesizedStackMetadata {
    "//"?: {
        [key: string]: TerraformStackMetadata;
    };
}
export interface SynthesizedStack extends StackManifest {
    content: string;
}
export declare class StackDependencies {
    private readonly stacks;
    pendingStacks: SynthesizedStack[];
    inflightStacks: SynthesizedStack[];
    deployedStacks: SynthesizedStack[];
    constructor(stacks: SynthesizedStack[]);
    startRun(stack: SynthesizedStack): void;
    finishRun(stack: SynthesizedStack): void;
    get pendingDeployableStacks(): SynthesizedStack[];
}
export type SynthOrigin = "watch";
export declare class SynthStack {
    static synth(abortSignal: AbortSignal, command: string, outdir: string, workingDirectory?: string, graceful?: boolean, // will not exit the process but rethrow the error instead
    noColor?: boolean, synthOrigin?: SynthOrigin, hcl?: boolean): Promise<SynthesizedStack[]>;
    static formatHclFiles(outDir: string): Promise<void>;
    static readSynthesizedStacks(outdir: string): Promise<SynthesizedStack[]>;
    static synthTelemetry(totalTime: number, stacks: SynthesizedStack[], synthOrigin?: SynthOrigin): Promise<void>;
    static synthErrorTelemetry(synthOrigin?: SynthOrigin): Promise<void>;
}
//# sourceMappingURL=synth-stack.d.ts.map