"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractJsonLogIfPresent = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
function extractJsonLogLineIfPresent(logLine) {
    try {
        const extractedMessage = JSON.parse(logLine)["@message"];
        return extractedMessage ? extractedMessage.trim() : logLine;
    }
    catch (e) {
        return logLine;
    }
}
function extractJsonLogIfPresent(logLines) {
    return logLines.split("\n").map(extractJsonLogLineIfPresent).join("\n");
}
exports.extractJsonLogIfPresent = extractJsonLogIfPresent;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVycmFmb3JtLWxvZ3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXJyYWZvcm0tbG9ncy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSwrQkFBK0I7QUFDL0IsbUNBQW1DO0FBQ25DLFNBQVMsMkJBQTJCLENBQUMsT0FBZTtJQUNsRCxJQUFJO1FBQ0YsTUFBTSxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3pELE9BQU8sZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLGdCQUFnQixDQUFDLElBQUksRUFBRSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUM7S0FDN0Q7SUFBQyxPQUFPLENBQUMsRUFBRTtRQUNWLE9BQU8sT0FBTyxDQUFDO0tBQ2hCO0FBQ0gsQ0FBQztBQUVELFNBQWdCLHVCQUF1QixDQUFDLFFBQWdCO0lBQ3RELE9BQU8sUUFBUSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxHQUFHLENBQUMsMkJBQTJCLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDMUUsQ0FBQztBQUZELDBEQUVDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSBIYXNoaUNvcnAsIEluY1xuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1QTC0yLjBcbmZ1bmN0aW9uIGV4dHJhY3RKc29uTG9nTGluZUlmUHJlc2VudChsb2dMaW5lOiBzdHJpbmcpOiBzdHJpbmcge1xuICB0cnkge1xuICAgIGNvbnN0IGV4dHJhY3RlZE1lc3NhZ2UgPSBKU09OLnBhcnNlKGxvZ0xpbmUpW1wiQG1lc3NhZ2VcIl07XG4gICAgcmV0dXJuIGV4dHJhY3RlZE1lc3NhZ2UgPyBleHRyYWN0ZWRNZXNzYWdlLnRyaW0oKSA6IGxvZ0xpbmU7XG4gIH0gY2F0Y2ggKGUpIHtcbiAgICByZXR1cm4gbG9nTGluZTtcbiAgfVxufVxuXG5leHBvcnQgZnVuY3Rpb24gZXh0cmFjdEpzb25Mb2dJZlByZXNlbnQobG9nTGluZXM6IHN0cmluZyk6IHN0cmluZyB7XG4gIHJldHVybiBsb2dMaW5lcy5zcGxpdChcIlxcblwiKS5tYXAoZXh0cmFjdEpzb25Mb2dMaW5lSWZQcmVzZW50KS5qb2luKFwiXFxuXCIpO1xufVxuIl19