"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.providerAdd = void 0;
const dependency_manager_1 = require("./dependencies/dependency-manager");
const init_1 = require("./init");
async function providerAdd({ providers, language, projectDirectory, cdktfVersion, dist, forceLocal, }) {
    const version = cdktfVersion || (await (0, init_1.determineDeps)(cdktfVersion, dist)).cdktf_version;
    const manager = new dependency_manager_1.DependencyManager(language, version, projectDirectory);
    let needsGet = false;
    for (const provider of providers) {
        const constraint = dependency_manager_1.ProviderConstraint.fromConfigEntry(provider);
        if (forceLocal) {
            needsGet = true;
            await manager.addLocalProvider(constraint);
        }
        else {
            const { addedLocalProvider } = await manager.addProvider(constraint);
            if (addedLocalProvider) {
                needsGet = true;
            }
        }
    }
    return needsGet;
}
exports.providerAdd = providerAdd;
//# sourceMappingURL=data:application/json;base64,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