"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getConstructIdsForOutputs = exports.parseOutput = exports.normalizeOutputPath = exports.saveOutputs = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const z = __importStar(require("zod"));
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const strip_ansi_1 = __importDefault(require("strip-ansi"));
const commons_1 = require("@cdktf/commons");
const schema_1 = require("./models/schema");
const terraform_1 = require("./models/terraform");
function unpackTerraformOutput(outputs, includeSensitiveOutputs) {
    return Object.entries(outputs).reduce((acc, [key, entry]) => ({
        ...acc,
        [key]: (0, terraform_1.isTerraformOutput)(entry)
            ? !entry.sensitive || includeSensitiveOutputs
                ? entry.value
                : undefined
            : unpackTerraformOutput(entry, includeSensitiveOutputs),
    }), {});
}
async function saveOutputs(filePath, outputs, includeSensitiveOutputs) {
    fs.writeFileSync(filePath, JSON.stringify(unpackTerraformOutput(outputs, includeSensitiveOutputs), null, 2));
}
exports.saveOutputs = saveOutputs;
function normalizeOutputPath(filePath) {
    return path.isAbsolute(filePath)
        ? filePath
        : path.join(process.cwd(), filePath);
}
exports.normalizeOutputPath = normalizeOutputPath;
const mapActionToState = (action, done) => {
    switch (action) {
        case "create":
        case "update":
            return done
                ? terraform_1.DeployingResourceApplyState.CREATED
                : terraform_1.DeployingResourceApplyState.CREATING;
        case "delete":
            return done
                ? terraform_1.DeployingResourceApplyState.DESTROYED
                : terraform_1.DeployingResourceApplyState.DESTROYING;
        default:
            return terraform_1.DeployingResourceApplyState.WAITING;
    }
};
// This is deprecated and will be removed in a future version.
const parseJsonOutputLine = (line) => {
    let json, message;
    try {
        json = JSON.parse(line);
    }
    catch (_a) {
        commons_1.logger.trace(`Could not parse line as JSON: ${line}`);
        return;
    }
    try {
        message = schema_1.schema.parse(json);
    }
    catch (err) {
        if (err instanceof z.ZodError) {
            commons_1.logger.trace(`Error parsing line into schema: ${JSON.stringify(err.errors)} => ${line}`);
        }
        return;
    }
    switch (message.type) {
        case "apply_start":
        case "apply_progress":
            return {
                id: message.hook.resource.resource,
                applyState: mapActionToState(message.hook.action, false),
            };
        case "apply_complete":
            return {
                id: message.hook.resource.resource,
                applyState: mapActionToState(message.hook.action, true),
            };
        default:
            return;
    }
};
const parseTextOutputLine = (line) => {
    if (/^Outputs:/.test(line)) {
        return;
    }
    if (/^Plan:/.test(line)) {
        return;
    }
    if (/^data\..*/.test(line)) {
        return;
    }
    const resourceMatch = line.match(/^([a-zA-Z_][a-zA-Z\d_\-.]*):/);
    let applyState;
    switch (true) {
        case /Creating.../.test(line):
        case /Still creating.../.test(line):
            applyState = terraform_1.DeployingResourceApplyState.CREATING;
            break;
        case /Creation complete/.test(line):
            applyState = terraform_1.DeployingResourceApplyState.CREATED;
            break;
        case /Modifying.../.test(line):
            applyState = terraform_1.DeployingResourceApplyState.UPDATING;
            break;
        case /Modifications complete/.test(line):
            applyState = terraform_1.DeployingResourceApplyState.UPDATED;
            break;
        case /Destroying.../.test(line):
        case /Still destroying.../.test(line):
            applyState = terraform_1.DeployingResourceApplyState.DESTROYING;
            break;
        case /Destruction complete/.test(line):
            applyState = terraform_1.DeployingResourceApplyState.DESTROYED;
            break;
        default:
            return;
    }
    if (resourceMatch &&
        resourceMatch.length >= 0 &&
        resourceMatch[1] != "Warning") {
        return {
            id: resourceMatch[1],
            applyState,
        };
    }
    else {
        return;
    }
};
const parseOutput = (str) => {
    const lines = (0, strip_ansi_1.default)(str.toString()).split("\n");
    const resources = lines.map((line) => {
        const parsed = parseJsonOutputLine(line) || parseTextOutputLine(line);
        if (parsed === undefined) {
            return;
        }
        const { id, applyState } = parsed;
        return {
            id,
            applyState,
            action: terraform_1.PlannedResourceAction.CREATE,
        };
    });
    return resources.reduce((acc, resource) => {
        if (resource) {
            acc.push(resource);
        }
        return acc;
        // eslint-disable-next-line @typescript-eslint/no-array-constructor
    }, new Array());
};
exports.parseOutput = parseOutput;
const isObjectEmpty = (obj) => {
    if (typeof obj !== "object") {
        return false;
    }
    return (Object.keys(obj).length === 0 ||
        Object.values(obj).every((v) => v === undefined || v === null || isObjectEmpty(v)));
};
const getConstructIdsForOutputs = (stackContent, outputs) => {
    // Older cdktf versions might not have the output metadata
    if (!("//" in stackContent) || !("outputs" in stackContent["//"])) {
        return outputs;
    }
    const outputsMapping = stackContent["//"].outputs;
    const mapOutputs = (value) => {
        return Object.entries(value).reduce((acc, [key, value]) => {
            if (typeof value === "string") {
                return { ...acc, [key]: outputs[value] };
            }
            const mapped = mapOutputs(value);
            if (isObjectEmpty(mapped)) {
                return acc;
            }
            return {
                ...acc,
                [key]: mapped,
            };
        }, {});
    };
    return mapOutputs(outputsMapping);
};
exports.getConstructIdsForOutputs = getConstructIdsForOutputs;
//# sourceMappingURL=data:application/json;base64,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