import { DeployingResource, TerraformOutput } from "./models/terraform";
export type Outputs = {
    [key: string]: TerraformOutput;
};
export type OutputIdMapLeaf = {
    [constructId: string]: string;
};
export type OutputIdMapNode = {
    [stackOrConstructId: string]: OutputIdMap;
};
export type OutputIdMap = OutputIdMapLeaf | OutputIdMapNode;
export declare function saveOutputs(filePath: string, outputs: NestedTerraformOutputs, includeSensitiveOutputs: boolean): Promise<void>;
export declare function normalizeOutputPath(filePath: string): string;
export type NestedTerraformOutputs = {
    [key: string]: TerraformOutput;
} | {
    [key: string]: NestedTerraformOutputs;
};
export declare const parseOutput: (str: string) => DeployingResource[];
export declare const getConstructIdsForOutputs: (stackContent: Record<string, any>, outputs: {
    [key: string]: TerraformOutput;
}) => NestedTerraformOutputs;
//# sourceMappingURL=output.d.ts.map