"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractTerraformPlan = exports.isTerraformOutput = exports.DeployingResourceApplyState = exports.PlannedResourceAction = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
var PlannedResourceAction;
(function (PlannedResourceAction) {
    PlannedResourceAction["CREATE"] = "create";
    PlannedResourceAction["UPDATE"] = "update";
    PlannedResourceAction["DELETE"] = "delete";
    PlannedResourceAction["READ"] = "read";
    PlannedResourceAction["NO_OP"] = "no-op";
})(PlannedResourceAction || (exports.PlannedResourceAction = PlannedResourceAction = {}));
var DeployingResourceApplyState;
(function (DeployingResourceApplyState) {
    DeployingResourceApplyState["WAITING"] = "waiting";
    DeployingResourceApplyState["UPDATING"] = "updating";
    DeployingResourceApplyState["UPDATED"] = "updated";
    DeployingResourceApplyState["CREATING"] = "creating";
    DeployingResourceApplyState["CREATED"] = "created";
    DeployingResourceApplyState["DESTROYING"] = "destroying";
    DeployingResourceApplyState["DESTROYED"] = "destroyed";
    DeployingResourceApplyState["SUCCESS"] = "success";
    DeployingResourceApplyState["ERROR"] = "error";
})(DeployingResourceApplyState || (exports.DeployingResourceApplyState = DeployingResourceApplyState = {}));
function isTerraformOutput(output) {
    return (typeof output === "object" &&
        typeof output.sensitive === "boolean" &&
        (typeof output.type === "string" || Array.isArray(output.type)));
}
exports.isTerraformOutput = isTerraformOutput;
function filterChangingResources(resources) {
    const applyActions = [
        PlannedResourceAction.UPDATE,
        PlannedResourceAction.CREATE,
        PlannedResourceAction.DELETE,
        PlannedResourceAction.READ,
    ];
    return resources.filter((resource) => applyActions.includes(resource.action));
}
class AbstractTerraformPlan {
    constructor(planFile, resourceChanges, outputChanges) {
        this.planFile = planFile;
        this.resourceChanges = resourceChanges;
        this.outputChanges = outputChanges;
    }
    get resources() {
        return (this.resourceChanges || []).map((resource) => {
            return {
                id: resource.address,
                action: resource.change.actions[0],
            };
        });
    }
    get applyableResources() {
        return filterChangingResources(this.resources);
    }
    get outputs() {
        return Object.entries(this.outputChanges || {}).map(([key, value]) => ({
            id: `output.${key}`,
            action: value.actions[0],
        }));
    }
    get changingOutputs() {
        return filterChangingResources(this.outputs);
    }
    get needsApply() {
        return (this.applyableResources.length > 0 || this.changingOutputs.length > 0);
    }
}
exports.AbstractTerraformPlan = AbstractTerraformPlan;
//# sourceMappingURL=data:application/json;base64,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