export declare enum PlannedResourceAction {
    CREATE = "create",
    UPDATE = "update",
    DELETE = "delete",
    READ = "read",
    NO_OP = "no-op"
}
export declare enum DeployingResourceApplyState {
    WAITING = "waiting",
    UPDATING = "updating",
    UPDATED = "updated",
    CREATING = "creating",
    CREATED = "created",
    DESTROYING = "destroying",
    DESTROYED = "destroyed",
    SUCCESS = "success",
    ERROR = "error"
}
export interface PlannedResource {
    id: string;
    action: PlannedResourceAction;
}
export interface DeployingResource extends PlannedResource {
    applyState: DeployingResourceApplyState;
}
export interface ResourceChangesChange {
    actions: string[];
    before: {
        [key: string]: any;
    };
    after: {
        [key: string]: any;
    };
}
export interface ResourceChanges {
    address: string;
    module_address: string;
    mode: string;
    type: string;
    name: string;
    index: number;
    provider_name: string;
    change: ResourceChangesChange;
}
export interface TerraformOutput {
    sensitive: boolean;
    type: string | Array<any>;
    value: string | Record<string, unknown> | Array<any>;
}
export declare function isTerraformOutput(output: any): output is TerraformOutput;
export interface TerraformPlan {
    readonly resources: PlannedResource[];
    readonly applyableResources: PlannedResource[];
    readonly needsApply: boolean;
    readonly planFile: string;
}
export declare abstract class AbstractTerraformPlan implements TerraformPlan {
    readonly planFile: string;
    private readonly resourceChanges;
    private readonly outputChanges;
    constructor(planFile: string, resourceChanges: ResourceChanges[], outputChanges: Record<string, ResourceChangesChange>);
    get resources(): PlannedResource[];
    get applyableResources(): PlannedResource[];
    get outputs(): PlannedResource[];
    get changingOutputs(): PlannedResource[];
    get needsApply(): boolean;
}
export type TerraformDeployState = {
    type: "running";
    cancelled: boolean;
} | {
    type: "waiting for approval";
    approve: () => void;
    reject: () => void;
} | {
    type: "waiting for sentinel override";
    override: () => void;
    reject: () => void;
} | {
    type: "external approval reply";
    approved: boolean;
} | {
    type: "external sentinel override reply";
    overridden: boolean;
};
export interface Terraform {
    init: (opts: {
        needsUpgrade: boolean;
        noColor?: boolean;
        needsLockfileUpdate: boolean;
        migrateState: boolean;
    }) => Promise<void>;
    plan: (opts: {
        destroy: boolean;
        refreshOnly?: boolean;
        parallelism?: number;
        vars?: string[];
        varFiles?: string[];
        noColor?: boolean;
    }) => Promise<void>;
    deploy(options: {
        autoApprove?: boolean;
        refreshOnly?: boolean;
        parallelism?: number;
        vars?: string[];
        varFiles?: string[];
        noColor?: boolean;
    }, callback: (state: TerraformDeployState) => void): Promise<{
        cancelled: boolean;
    }>;
    destroy(options: {
        autoApprove?: boolean;
        parallelism?: number;
        vars?: string[];
        varFiles?: string[];
        noColor?: boolean;
    }, callback: (state: TerraformDeployState) => void): Promise<{
        cancelled: boolean;
    }>;
    output(): Promise<{
        [key: string]: TerraformOutput;
    }>;
    abort: () => Promise<void>;
}
//# sourceMappingURL=terraform.d.ts.map