"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryRemoveGeneratedConfigurationFile = exports.tryReadGeneratedConfigurationFile = exports.TerraformCli = exports.TerraformCliPlan = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const strip_ansi_1 = __importDefault(require("strip-ansi"));
const commons_1 = require("@cdktf/commons");
const terraform_1 = require("./terraform");
const deploy_machine_1 = require("./deploy-machine");
const waitFor_1 = require("xstate/lib/waitFor");
const errors_1 = require("../errors");
const terraform_json_1 = require("../terraform-json");
const pty_process_1 = require("./pty-process");
const path_1 = __importDefault(require("path"));
const fs = __importStar(require("fs-extra"));
const GENERATE_CONFIG_OUT_FILE = "generated_resources.tf";
class TerraformCliPlan extends terraform_1.AbstractTerraformPlan {
    constructor(planFile, plan) {
        super(planFile, plan === null || plan === void 0 ? void 0 : plan.resource_changes, plan === null || plan === void 0 ? void 0 : plan.output_changes);
        this.planFile = planFile;
        this.plan = plan;
    }
}
exports.TerraformCliPlan = TerraformCliPlan;
class AbstractOutputFilter {
}
// The plan might error if there is a variable missing, but the error message hints the user
// in a wrong direction. We therefore catch the error and rethrow it with a more helpful message
class VariableRequiredFilter extends AbstractOutputFilter {
    // Example for "No value for required variable" error
    // ╷
    // │ Error: No value for required variable
    // │
    // │   on cdk.tf.json line 31, in variable:
    // │   31:     "with-dashes": {
    // │
    // │ The root module input variable "with-dashes" is not set, and has no default
    // │ value. Use a -var or -var-file command line argument to provide a value for
    // │ this variable
    static condition(input) {
        const line = (0, strip_ansi_1.default)(input);
        return (line.includes("Error: No value for required variable") &&
            line.includes("The root module input variable"));
    }
    static transform(line) {
        const startMarker = 'The root module input variable "';
        const variableName = line.substring(line.indexOf(startMarker) + startMarker.length, line.indexOf('" is not set'));
        return (0, errors_1.missingVariable)(variableName);
    }
}
class TerraformCli {
    constructor(abortSignal, stack, createTerraformLogHandler = (_phase, _filter) => (_stdout, _isErr = false) => { }) {
        this.abortSignal = abortSignal;
        this.stack = stack;
        this.workdir = stack.workingDirectory;
        this.onStdout =
            (phase, filter) => (stdout) => createTerraformLogHandler(phase, filter)(Buffer.isBuffer(stdout) ? stdout.toString() : stdout);
        this.onStderr =
            (phase, filter) => (stderr) => createTerraformLogHandler(phase, filter)(stderr.toString(), true);
    }
    async init(opts) {
        await this.setUserAgent();
        const args = ["init"];
        if (opts.needsUpgrade) {
            args.push("-upgrade");
        }
        if (opts.noColor) {
            args.push("-no-color");
        }
        if (opts.migrateState) {
            args.push("-migrate-state");
        }
        // eslint-disable-next-line @typescript-eslint/no-empty-function
        let initCanNotContinue = (_err) => { };
        const rejectsIfInitCanNotContinue = new Promise((_resolve, reject) => {
            initCanNotContinue = reject;
        });
        const stdout = this.onStdout("init");
        const { actions, exitCode } = (0, pty_process_1.spawnPty)({
            file: commons_1.terraformBinaryName,
            args,
            options: {
                cwd: this.workdir,
                env: process.env,
            },
        }, (data) => {
            stdout(data);
            if (data.includes("Should Terraform migrate your existing state?") ||
                data.includes("Do you want to copy existing state to the new backend")) {
                // TODO: This only happens when terraform is passed the -migrate-state anyway, so this check is redundant
                if (opts.migrateState) {
                    actions.writeLine("yes");
                }
                else {
                    actions.stop();
                    initCanNotContinue("Please pass the --migrate-state flag to migrate your state");
                }
            }
        });
        this.abortSignal.addEventListener("abort", () => {
            actions.stop();
        });
        const progress = exitCode.then((code) => {
            if (code !== 0) {
                throw new Error(`terraform init failed with exit code ${code}`);
            }
        });
        await Promise.race([progress, rejectsIfInitCanNotContinue]);
        // TODO: this might have performance implications because we don't know if we're
        // running a remote plan or a local one (so we run it always for all platforms)
        // while we'd only need it for remote plans
        if (opts.needsLockfileUpdate) {
            await (0, commons_1.exec)(commons_1.terraformBinaryName, [
                "providers",
                "lock",
                "-platform=linux_amd64",
                ...(opts.noColor ? ["-no-color"] : []),
            ], {
                cwd: this.workdir,
                env: process.env,
                signal: this.abortSignal,
                noColor: opts.noColor,
            }, this.onStdout("init"), this.onStderr("init"));
        }
    }
    get isCloudStack() {
        var _a, _b, _c;
        const parsedStack = terraform_json_1.terraformJsonSchema.parse(JSON.parse(this.stack.content));
        return Boolean(((_b = (_a = parsedStack.terraform) === null || _a === void 0 ? void 0 : _a.backend) === null || _b === void 0 ? void 0 : _b.remote) || ((_c = parsedStack.terraform) === null || _c === void 0 ? void 0 : _c.cloud));
    }
    get hasImports() {
        const parsedStack = terraform_json_1.terraformJsonSchema.parse(JSON.parse(this.stack.content));
        return Boolean(parsedStack.import);
    }
    async plan(opts) {
        const { destroy = false, refreshOnly = false, parallelism = -1, vars = [], varFiles = [], noColor = false, } = opts;
        const options = ["plan", "-input=false"];
        const generatedConfigFile = path_1.default.join(this.workdir, GENERATE_CONFIG_OUT_FILE);
        if (fs.existsSync(generatedConfigFile)) {
            fs.remove(generatedConfigFile);
        }
        if (this.hasImports) {
            options.push(`-generate-config-out=${GENERATE_CONFIG_OUT_FILE}`);
        }
        if (!this.isCloudStack) {
            const planFile = "plan";
            options.push("-out", planFile);
        }
        if (destroy) {
            options.push("-destroy");
        }
        if (refreshOnly) {
            options.push("-refresh-only");
        }
        if (parallelism > -1) {
            options.push(`-parallelism=${parallelism}`);
        }
        if (noColor) {
            options.push("-no-color");
        }
        vars.forEach((v) => options.push(`-var=${v}`));
        varFiles.forEach((v) => options.push(`-var-file=${v}`));
        commons_1.logger.debug(`Executing ${commons_1.terraformBinaryName} ${options.join(" ")} in ${this.workdir}`);
        await this.setUserAgent();
        await (0, commons_1.exec)(commons_1.terraformBinaryName, options, {
            cwd: this.workdir,
            env: process.env,
            signal: this.abortSignal,
            noColor,
        }, this.onStdout("plan", [VariableRequiredFilter]), this.onStderr("plan", [VariableRequiredFilter]));
    }
    async deploy({ autoApprove = false, refreshOnly = false, noColor = false, parallelism = -1, extraOptions = [], vars = [], varFiles = [], }, callback) {
        await this.setUserAgent();
        const service = (0, deploy_machine_1.createAndStartDeployService)({
            terraformBinaryName: commons_1.terraformBinaryName,
            workdir: this.workdir,
            refreshOnly,
            noColor,
            autoApprove,
            parallelism,
            extraOptions,
            vars,
            varFiles,
        });
        return this.handleService("deploy", service, callback);
    }
    async destroy({ autoApprove = false, parallelism = -1, noColor = false, extraOptions = [], vars = [], varFiles = [], }, callback) {
        await this.setUserAgent();
        const service = (0, deploy_machine_1.createAndStartDestroyService)({
            terraformBinaryName: commons_1.terraformBinaryName,
            workdir: this.workdir,
            autoApprove,
            parallelism,
            noColor,
            extraOptions,
            vars,
            varFiles,
        });
        return this.handleService("destroy", service, callback);
    }
    async handleService(type, service, callback) {
        // stop terraform apply if signaled as such from the outside (e.g. via ctrl+c)
        this.abortSignal.addEventListener("abort", () => {
            service.send("STOP");
        }, { once: true });
        // relay logs to stdout
        service.onEvent((event) => {
            commons_1.logger.trace(`Terraform CLI state machine event: ${JSON.stringify(event)}`);
            if ((0, deploy_machine_1.isDeployEvent)(event, "OUTPUT_RECEIVED"))
                this.onStdout(type)(event.output);
            else if ((0, deploy_machine_1.isDeployEvent)(event, "APPROVED_EXTERNALLY"))
                callback({ type: "external approval reply", approved: true });
            else if ((0, deploy_machine_1.isDeployEvent)(event, "REJECTED_EXTERNALLY"))
                callback({ type: "external approval reply", approved: false });
            else if ((0, deploy_machine_1.isDeployEvent)(event, "OVERRIDDEN_EXTERNALLY"))
                callback({
                    type: "external sentinel override reply",
                    overridden: true,
                });
            else if ((0, deploy_machine_1.isDeployEvent)(event, "OVERRIDE_REJECTED_EXTERNALLY"))
                callback({
                    type: "external sentinel override reply",
                    overridden: false,
                });
        });
        let previousState = "idle";
        service.onTransition((state) => {
            // only send updates on actual state change
            // onTransition is called even if the state didn't change but only an event happened
            if (state.matches(previousState))
                return;
            commons_1.logger.trace(`Terraform CLI state machine state transition: ${JSON.stringify(previousState)} => ${JSON.stringify(state.value)}`);
            if (state.matches({ running: "awaiting_approval" })) {
                callback({
                    type: "waiting for approval",
                    approve: () => service.send("APPROVE"),
                    reject: () => service.send("REJECT"),
                });
            }
            else if (state.matches({ running: "awaiting_sentinel_override" })) {
                callback({
                    type: "waiting for sentinel override",
                    override: () => service.send("OVERRIDE"),
                    reject: () => service.send("REJECT_OVERRIDE"),
                });
            }
            else if (state.matches({ running: "processing" })) {
                callback({
                    type: "running",
                    cancelled: Boolean(state.context.cancelled),
                });
            }
            previousState = state.value;
        });
        service.start();
        const state = await (0, waitFor_1.waitFor)(service, (state) => !!state.done, {
            timeout: Infinity,
        });
        commons_1.logger.trace(`Invoking Terraform CLI for ${type} done (state machine reached final state). Last event: ${JSON.stringify(state.event)}. Context: ${JSON.stringify(state.context)}`);
        // example events: { type: 'EXITED', exitCode: 0 }, { type: 'EXTERNAL_REJECT' }
        if (state.event.type === "EXITED" &&
            state.event.exitCode !== 0 &&
            !state.context.cancelled // don't fail if we cancelled the run
        ) {
            throw `Invoking Terraform CLI failed with exit code ${state.event.exitCode}`;
        }
        return { cancelled: Boolean(state.context.cancelled) };
    }
    async version() {
        try {
            return await (0, commons_1.exec)(commons_1.terraformBinaryName, ["-v"], {
                cwd: this.workdir,
                env: process.env,
                signal: this.abortSignal,
                noColor: true,
            }, this.onStdout("version"), this.onStderr("version"));
        }
        catch (_a) {
            throw new Error("Terraform CLI not present - Please install a current version https://learn.hashicorp.com/terraform/getting-started/install.html");
        }
    }
    async output() {
        const output = await (0, commons_1.exec)(commons_1.terraformBinaryName, ["output", "-json"], {
            cwd: this.workdir,
            env: process.env,
            signal: this.abortSignal,
            noColor: true,
        }, 
        // We don't need to log the output here since we use it later on
        () => { }, // eslint-disable-line @typescript-eslint/no-empty-function
        this.onStderr("output"));
        try {
            return JSON.parse(output);
        }
        catch (e) {
            throw commons_1.Errors.External(`Failed to parse terraform output: ${e}. The output was '${output}'`);
        }
    }
    async setUserAgent() {
        // Read the cdktf version from the 'cdk.tf.json' file
        // and set the user agent.
        const version = await (0, commons_1.readCDKTFVersion)(this.workdir);
        if (version != "") {
            process.env.TF_APPEND_USER_AGENT =
                "cdktf/" + version + " (+https://github.com/hashicorp/terraform-cdk)";
        }
    }
    // We don't need to clean anything up for a running execution in the CLI since there is no left-over state in contrast to an open Terraform Cloud run
    async abort() {
        return;
    }
}
exports.TerraformCli = TerraformCli;
async function tryReadGeneratedConfigurationFile(workingDir) {
    const generatedConfigPath = path_1.default.join(workingDir, GENERATE_CONFIG_OUT_FILE);
    if (!fs.existsSync(generatedConfigPath)) {
        return null;
    }
    return fs.readFileSync(generatedConfigPath, "utf-8");
}
exports.tryReadGeneratedConfigurationFile = tryReadGeneratedConfigurationFile;
async function tryRemoveGeneratedConfigurationFile(workingDir) {
    const generatedConfigPath = path_1.default.join(workingDir, GENERATE_CONFIG_OUT_FILE);
    if (fs.existsSync(generatedConfigPath)) {
        fs.unlinkSync(generatedConfigPath);
    }
}
exports.tryRemoveGeneratedConfigurationFile = tryRemoveGeneratedConfigurationFile;
//# sourceMappingURL=data:application/json;base64,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