import { Terraform, TerraformPlan, TerraformOutput, AbstractTerraformPlan, TerraformDeployState } from "./terraform";
import { SynthesizedStack } from "../synth-stack";
export declare class TerraformCliPlan extends AbstractTerraformPlan implements TerraformPlan {
    readonly planFile: string;
    readonly plan: {
        [key: string]: any;
    };
    constructor(planFile: string, plan: {
        [key: string]: any;
    });
}
declare abstract class AbstractOutputFilter {
    static condition: (line: string) => boolean;
    static transform: (line: string) => string;
}
export type OutputFilter = typeof AbstractOutputFilter;
export declare class TerraformCli implements Terraform {
    private readonly abortSignal;
    readonly stack: SynthesizedStack;
    readonly workdir: string;
    private readonly onStdout;
    private readonly onStderr;
    constructor(abortSignal: AbortSignal, stack: SynthesizedStack, createTerraformLogHandler?: (_phase: string, _filter?: OutputFilter[]) => (_stdout: string, _isErr?: boolean) => void);
    init(opts: {
        needsUpgrade: boolean;
        noColor?: boolean;
        migrateState: boolean;
        needsLockfileUpdate: boolean;
    }): Promise<void>;
    private get isCloudStack();
    private get hasImports();
    plan(opts: {
        destroy: boolean;
        refreshOnly?: boolean;
        parallelism?: number;
        vars?: string[];
        varFiles?: string[];
        noColor?: boolean;
    }): Promise<void>;
    deploy({ autoApprove, refreshOnly, noColor, parallelism, extraOptions, vars, varFiles, }: {
        autoApprove?: boolean | undefined;
        refreshOnly?: boolean | undefined;
        noColor?: boolean | undefined;
        parallelism?: number | undefined;
        extraOptions?: never[] | undefined;
        vars?: never[] | undefined;
        varFiles?: never[] | undefined;
    }, callback: (state: TerraformDeployState) => void): Promise<{
        cancelled: boolean;
    }>;
    destroy({ autoApprove, parallelism, noColor, extraOptions, vars, varFiles, }: {
        autoApprove?: boolean | undefined;
        parallelism?: number | undefined;
        noColor?: boolean | undefined;
        extraOptions?: never[] | undefined;
        vars?: never[] | undefined;
        varFiles?: never[] | undefined;
    }, callback: (state: TerraformDeployState) => void): Promise<{
        cancelled: boolean;
    }>;
    private handleService;
    version(): Promise<string>;
    output(): Promise<{
        [key: string]: TerraformOutput;
    }>;
    setUserAgent(): Promise<void>;
    abort(): Promise<void>;
}
export declare function tryReadGeneratedConfigurationFile(workingDir: string): Promise<string | null>;
export declare function tryRemoveGeneratedConfigurationFile(workingDir: string): Promise<void>;
export {};
//# sourceMappingURL=terraform-cli.d.ts.map