"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.schema = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const z = __importStar(require("zod"));
// Schemas from https://www.terraform.io/docs/internals/machine-readable-ui.html#change_summary
const resource = z.object({
    addr: z.string(),
    module: z.string(),
    resource: z.string(),
    implied_provider: z.string(),
    resource_type: z.string(),
    resource_name: z.string(),
    resource_key: z.string().optional().nullable(),
});
const baseMessage = z
    .object({
    "@level": z.enum(["info", "error", "warn"]),
    "@message": z.string(),
    "@module": z.string(),
    "@timestamp": z.string(),
})
    .nonstrict();
const action = z.enum(["noop", "create", "read", "update", "delete"]);
const change = z.object({
    resource,
    action,
});
const replaceChange = change.extend({
    action: z.literal("replace"),
    reason: z.enum(["tainted", "requested", "cannot_update"]),
});
const plannedChange = baseMessage.extend({
    type: z.literal("planned_change"),
    change: z.union([replaceChange, change]),
});
const version = baseMessage.extend({
    type: z.literal("version"),
});
const changeSummary = baseMessage.extend({
    type: z.literal("change_summary"),
    changes: z.object({
        add: z.number(),
        change: z.number(),
        remove: z.number(),
        operation: z.enum(["plan", "apply", "deploy"]),
    }),
});
const outputs = baseMessage.extend({
    type: z.literal("outputs"),
    outputs: z.record(z.object({
        sensitive: z.boolean(),
        type: z.string(),
        value: z.string(),
    })),
});
const applyStart = baseMessage.extend({
    type: z.literal("apply_start"),
    hook: z.object({
        resource,
        action,
        id_key: z.string().optional(),
        id_value: z.string().optional(),
    }),
});
const applyProgress = baseMessage.extend({
    type: z.literal("apply_progress"),
    hook: z.object({
        resource,
        action,
        elapsed_seconds: z.number(),
    }),
});
const applyComplete = baseMessage.extend({
    type: z.literal("apply_complete"),
    hook: z.object({
        resource,
        action,
        id_key: z.string().optional(),
        id_value: z.string().optional(),
        elapsed_seconds: z.number(),
    }),
});
const applyError = baseMessage.extend({
    type: z.literal("apply_errored"),
    hook: z.object({
        resource,
        action,
        elapsed_seconds: z.number(),
    }),
});
const provisionStart = baseMessage.extend({
    type: z.literal("provision_start"),
    hook: z.object({
        resource,
        provisioner: z.string(),
    }),
});
const provisionProgress = baseMessage.extend({
    type: z.literal("provision_progress"),
    hook: z.object({
        resource,
        provisioner: z.string(),
        output: z.string(),
    }),
});
const provisionComplete = baseMessage.extend({
    type: z.literal("provision_complete"),
    hook: z.object({
        resource,
        provisioner: z.string(),
    }),
});
const provisionErrored = baseMessage.extend({
    type: z.literal("provision_errored"),
    hook: z.object({
        resource,
        provisioner: z.string(),
    }),
});
const refreshStart = baseMessage.extend({
    type: z.literal("refresh_start"),
    hook: z.object({
        resource,
        id_key: z.string().optional(),
        id_value: z.string().optional(),
    }),
});
const refreshComplete = baseMessage.extend({
    type: z.literal("refresh_complete"),
    hook: z.object({
        resource,
        id_key: z.string().optional(),
        id_value: z.string().optional(),
    }),
});
const logMessage = baseMessage.extend({
    type: z.literal("log"),
});
exports.schema = z.union([
    version,
    plannedChange,
    changeSummary,
    outputs,
    applyStart,
    applyProgress,
    applyComplete,
    applyError,
    provisionStart,
    provisionProgress,
    provisionComplete,
    provisionErrored,
    refreshStart,
    refreshComplete,
    logMessage,
]);
//# sourceMappingURL=data:application/json;base64,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