import * as z from "zod";
declare const action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
export declare const schema: z.ZodUnion<[z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"version">;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"version">;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"version">;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"planned_change">;
    change: z.ZodUnion<[z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
    } & {
        action: z.ZodLiteral<"replace">;
        reason: z.ZodEnum<["tainted", "requested", "cannot_update"]>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "replace";
        reason: "tainted" | "requested" | "cannot_update";
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "replace";
        reason: "tainted" | "requested" | "cannot_update";
    }>, z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
    }>]>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"planned_change">;
    change: z.ZodUnion<[z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
    } & {
        action: z.ZodLiteral<"replace">;
        reason: z.ZodEnum<["tainted", "requested", "cannot_update"]>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "replace";
        reason: "tainted" | "requested" | "cannot_update";
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "replace";
        reason: "tainted" | "requested" | "cannot_update";
    }>, z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
    }>]>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"planned_change">;
    change: z.ZodUnion<[z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
    } & {
        action: z.ZodLiteral<"replace">;
        reason: z.ZodEnum<["tainted", "requested", "cannot_update"]>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "replace";
        reason: "tainted" | "requested" | "cannot_update";
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "replace";
        reason: "tainted" | "requested" | "cannot_update";
    }>, z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
    }>]>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"change_summary">;
    changes: z.ZodObject<{
        add: z.ZodNumber;
        change: z.ZodNumber;
        remove: z.ZodNumber;
        operation: z.ZodEnum<["plan", "apply", "deploy"]>;
    }, "strip", z.ZodTypeAny, {
        change: number;
        add: number;
        remove: number;
        operation: "plan" | "apply" | "deploy";
    }, {
        change: number;
        add: number;
        remove: number;
        operation: "plan" | "apply" | "deploy";
    }>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"change_summary">;
    changes: z.ZodObject<{
        add: z.ZodNumber;
        change: z.ZodNumber;
        remove: z.ZodNumber;
        operation: z.ZodEnum<["plan", "apply", "deploy"]>;
    }, "strip", z.ZodTypeAny, {
        change: number;
        add: number;
        remove: number;
        operation: "plan" | "apply" | "deploy";
    }, {
        change: number;
        add: number;
        remove: number;
        operation: "plan" | "apply" | "deploy";
    }>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"change_summary">;
    changes: z.ZodObject<{
        add: z.ZodNumber;
        change: z.ZodNumber;
        remove: z.ZodNumber;
        operation: z.ZodEnum<["plan", "apply", "deploy"]>;
    }, "strip", z.ZodTypeAny, {
        change: number;
        add: number;
        remove: number;
        operation: "plan" | "apply" | "deploy";
    }, {
        change: number;
        add: number;
        remove: number;
        operation: "plan" | "apply" | "deploy";
    }>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"outputs">;
    outputs: z.ZodRecord<z.ZodString, z.ZodObject<{
        sensitive: z.ZodBoolean;
        type: z.ZodString;
        value: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        value: string;
        type: string;
        sensitive: boolean;
    }, {
        value: string;
        type: string;
        sensitive: boolean;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"outputs">;
    outputs: z.ZodRecord<z.ZodString, z.ZodObject<{
        sensitive: z.ZodBoolean;
        type: z.ZodString;
        value: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        value: string;
        type: string;
        sensitive: boolean;
    }, {
        value: string;
        type: string;
        sensitive: boolean;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"outputs">;
    outputs: z.ZodRecord<z.ZodString, z.ZodObject<{
        sensitive: z.ZodBoolean;
        type: z.ZodString;
        value: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        value: string;
        type: string;
        sensitive: boolean;
    }, {
        value: string;
        type: string;
        sensitive: boolean;
    }>>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"apply_start">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
        id_key: z.ZodOptional<z.ZodString>;
        id_value: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        id_key?: string | undefined;
        id_value?: string | undefined;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        id_key?: string | undefined;
        id_value?: string | undefined;
    }>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"apply_start">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
        id_key: z.ZodOptional<z.ZodString>;
        id_value: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        id_key?: string | undefined;
        id_value?: string | undefined;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        id_key?: string | undefined;
        id_value?: string | undefined;
    }>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"apply_start">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
        id_key: z.ZodOptional<z.ZodString>;
        id_value: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        id_key?: string | undefined;
        id_value?: string | undefined;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        id_key?: string | undefined;
        id_value?: string | undefined;
    }>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"apply_progress">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
        elapsed_seconds: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
    }>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"apply_progress">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
        elapsed_seconds: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
    }>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"apply_progress">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
        elapsed_seconds: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
    }>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"apply_complete">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
        id_key: z.ZodOptional<z.ZodString>;
        id_value: z.ZodOptional<z.ZodString>;
        elapsed_seconds: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
        id_key?: string | undefined;
        id_value?: string | undefined;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
        id_key?: string | undefined;
        id_value?: string | undefined;
    }>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"apply_complete">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
        id_key: z.ZodOptional<z.ZodString>;
        id_value: z.ZodOptional<z.ZodString>;
        elapsed_seconds: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
        id_key?: string | undefined;
        id_value?: string | undefined;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
        id_key?: string | undefined;
        id_value?: string | undefined;
    }>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"apply_complete">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
        id_key: z.ZodOptional<z.ZodString>;
        id_value: z.ZodOptional<z.ZodString>;
        elapsed_seconds: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
        id_key?: string | undefined;
        id_value?: string | undefined;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
        id_key?: string | undefined;
        id_value?: string | undefined;
    }>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"apply_errored">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
        elapsed_seconds: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
    }>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"apply_errored">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
        elapsed_seconds: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
    }>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"apply_errored">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        action: z.ZodEnum<["noop", "create", "read", "update", "delete"]>;
        elapsed_seconds: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        action: "create" | "update" | "delete" | "read" | "noop";
        elapsed_seconds: number;
    }>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"provision_start">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        provisioner: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"provision_start">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        provisioner: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"provision_start">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        provisioner: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"provision_progress">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        provisioner: z.ZodString;
        output: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        output: string;
        provisioner: string;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        output: string;
        provisioner: string;
    }>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"provision_progress">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        provisioner: z.ZodString;
        output: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        output: string;
        provisioner: string;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        output: string;
        provisioner: string;
    }>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"provision_progress">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        provisioner: z.ZodString;
        output: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        output: string;
        provisioner: string;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        output: string;
        provisioner: string;
    }>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"provision_complete">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        provisioner: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"provision_complete">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        provisioner: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"provision_complete">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        provisioner: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"provision_errored">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        provisioner: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"provision_errored">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        provisioner: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"provision_errored">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        provisioner: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        provisioner: string;
    }>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"refresh_start">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        id_key: z.ZodOptional<z.ZodString>;
        id_value: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        id_key?: string | undefined;
        id_value?: string | undefined;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        id_key?: string | undefined;
        id_value?: string | undefined;
    }>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"refresh_start">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        id_key: z.ZodOptional<z.ZodString>;
        id_value: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        id_key?: string | undefined;
        id_value?: string | undefined;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        id_key?: string | undefined;
        id_value?: string | undefined;
    }>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"refresh_start">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        id_key: z.ZodOptional<z.ZodString>;
        id_value: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        id_key?: string | undefined;
        id_value?: string | undefined;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        id_key?: string | undefined;
        id_value?: string | undefined;
    }>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"refresh_complete">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        id_key: z.ZodOptional<z.ZodString>;
        id_value: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        id_key?: string | undefined;
        id_value?: string | undefined;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        id_key?: string | undefined;
        id_value?: string | undefined;
    }>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"refresh_complete">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        id_key: z.ZodOptional<z.ZodString>;
        id_value: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        id_key?: string | undefined;
        id_value?: string | undefined;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        id_key?: string | undefined;
        id_value?: string | undefined;
    }>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"refresh_complete">;
    hook: z.ZodObject<{
        resource: z.ZodObject<{
            addr: z.ZodString;
            module: z.ZodString;
            resource: z.ZodString;
            implied_provider: z.ZodString;
            resource_type: z.ZodString;
            resource_name: z.ZodString;
            resource_key: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }, {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        }>;
        id_key: z.ZodOptional<z.ZodString>;
        id_value: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        id_key?: string | undefined;
        id_value?: string | undefined;
    }, {
        resource: {
            module: string;
            resource: string;
            addr: string;
            implied_provider: string;
            resource_type: string;
            resource_name: string;
            resource_key?: string | null | undefined;
        };
        id_key?: string | undefined;
        id_value?: string | undefined;
    }>;
}, z.ZodTypeAny, "passthrough">>, z.ZodObject<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"log">;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"log">;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    "@level": z.ZodEnum<["info", "error", "warn"]>;
    "@message": z.ZodString;
    "@module": z.ZodString;
    "@timestamp": z.ZodString;
} & {
    type: z.ZodLiteral<"log">;
}, z.ZodTypeAny, "passthrough">>]>;
export type ActionTypes = z.infer<typeof action>;
export {};
//# sourceMappingURL=schema.d.ts.map