"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.spawnPty = void 0;
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const fs = __importStar(require("fs"));
const pty = __importStar(require("@cdktf/node-pty-prebuilt-multiarch"));
const commons_1 = require("@cdktf/commons");
/**
 * A wrapper around node-pty that handles the platform specific differences
 * and provide an intuitive API for bidirectional communication with the
 * spawned process.
 */
function spawnPty(config, onData) {
    const { args, options } = config;
    const file = os.platform() === "win32"
        ? findExecutable(config.file, options.cwd, options)
        : config.file;
    commons_1.logger.trace(`Spawning pty with file=${file}, args=${Array.isArray(args) ? `[${args.join(", ")}]` : `"${args}"`}, options=${JSON.stringify(options)}`);
    const p = pty.spawn(file, args, options);
    const actions = {
        write: (response) => {
            commons_1.logger.trace(`Sending response to pty (file=${file}, args=${Array.isArray(args) ? `[${args.join(", ")}]` : `"${args}"`}): ${response}`);
            p.write(response);
        },
        writeLine: (response) => {
            commons_1.logger.trace(`Sending response (with newline) to pty (file=${file}, args=${Array.isArray(args) ? `[${args.join(", ")}]` : `"${args}"`}): ${response}`);
            p.write(`${response}${os.EOL}`);
        },
        stop: () => {
            commons_1.logger.trace(`Aborting pty (file=${file}, args=${Array.isArray(args) ? `[${args.join(", ")}]` : `"${args}"`})`);
            p.write("\x03"); // CTRL + C, pty.kill() does not work on windows
        },
    };
    p.onData((data) => onData(data));
    const exitCode = new Promise((resolve) => {
        p.onExit(({ exitCode }) => {
            if (exitCode !== 0) {
                commons_1.logger.debug(`Pty (file=${file}, args=${Array.isArray(args) ? `[${args.join(", ")}]` : `"${args}"`}) exited with code ${exitCode}`);
            }
            resolve(exitCode);
        });
    });
    return { exitCode, actions };
}
exports.spawnPty = spawnPty;
// src: https://github.com/Microsoft/vscode/blob/c0c9ea27d6e8d660d8716d7acee82cf3c00fa3e5/src/vs/workbench/parts/tasks/electron-browser/terminalTaskSystem.ts#L691
// TODO: properly annotate source of this function
function findExecutable(command, cwd, options) {
    // If we have an absolute path then we take it.
    if (path.isAbsolute(command)) {
        return command;
    }
    const dir = path.dirname(command);
    if (dir !== ".") {
        // We have a directory and the directory is relative (see above). Make the path absolute
        // to the current working directory.
        return path.join(cwd, command);
    }
    let paths = undefined;
    // The options can override the PATH. So consider that PATH if present.
    if (options && options.env) {
        // Path can be named in many different ways and for the execution it doesn't matter
        for (const key of Object.keys(options.env)) {
            if (key.toLowerCase() === "path") {
                if (typeof options.env[key] === "string") {
                    paths = options.env[key].split(path.delimiter);
                }
                break;
            }
        }
    }
    if (paths === void 0 && typeof process.env.PATH === "string") {
        paths = process.env.PATH.split(path.delimiter);
    }
    // No PATH environment. Make path absolute to the cwd.
    if (paths === void 0 || paths.length === 0) {
        return path.join(cwd, command);
    }
    // We have a simple file name. We get the path variable from the env
    // and try to find the executable on the path.
    for (const pathEntry of paths) {
        // The path entry is absolute.
        let fullPath;
        if (path.isAbsolute(pathEntry)) {
            fullPath = path.join(pathEntry, command);
        }
        else {
            fullPath = path.join(cwd, pathEntry, command);
        }
        if (fs.existsSync(fullPath)) {
            return fullPath;
        }
        let withExtension = fullPath + ".com";
        if (fs.existsSync(withExtension)) {
            return withExtension;
        }
        withExtension = fullPath + ".exe";
        if (fs.existsSync(withExtension)) {
            return withExtension;
        }
    }
    return path.join(cwd, command);
}
//# sourceMappingURL=data:application/json;base64,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