/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import * as pty from "@cdktf/node-pty-prebuilt-multiarch";
interface PtySpawnConfig {
    file: Parameters<typeof pty.spawn>[0];
    args: Parameters<typeof pty.spawn>[1];
    options: Parameters<typeof pty.spawn>[2] & {
        cwd: string;
    };
}
export interface PtyProcessActions {
    write: (response: string) => void;
    writeLine: (response: string) => void;
    stop: () => void;
}
export interface PtyProcess {
    exitCode: Promise<number>;
    actions: PtyProcessActions;
}
/**
 * A wrapper around node-pty that handles the platform specific differences
 * and provide an intuitive API for bidirectional communication with the
 * spawned process.
 */
export declare function spawnPty(config: PtySpawnConfig, onData: (data: string) => void): PtyProcess;
export {};
//# sourceMappingURL=pty-process.d.ts.map