/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { EventObject, Sender, Receiver } from "xstate";
import * as pty from "@cdktf/node-pty-prebuilt-multiarch";
import { spawnPty } from "./pty-process";
interface PtySpawnConfig {
    file: Parameters<typeof pty.spawn>[0];
    args: Parameters<typeof pty.spawn>[1];
    options: Parameters<typeof pty.spawn>[2] & {
        cwd: string;
    };
}
interface DeployContext {
    exitCode?: number;
    /**
     * Terraform will exit with 1 if it was cancelled, but we don't want to fail in that case
     */
    cancelled?: boolean;
}
export type DeployEvent = {
    type: "START";
    pty: PtySpawnConfig;
} | {
    type: "STOP";
} | {
    type: "SEND_LINE";
    input: string;
} | {
    type: "OUTPUT_RECEIVED";
    output: string;
} | {
    type: "APPROVED_EXTERNALLY";
} | {
    type: "REJECTED_EXTERNALLY";
} | {
    type: "OVERRIDDEN_EXTERNALLY";
} | {
    type: "OVERRIDE_REJECTED_EXTERNALLY";
} | {
    type: "OVERRIDE";
} | {
    type: "REJECT_OVERRIDE";
} | {
    type: "REQUEST_APPROVAL";
} | {
    type: "VARIABLE_MISSING";
    variableName: string;
} | {
    type: "REQUEST_SENTINEL_OVERRIDE";
} | {
    type: "APPROVE";
} | {
    type: "REJECT";
} | {
    type: "EXITED";
    exitCode: number;
};
export declare function isDeployEvent<DeployEventType extends DeployEvent["type"]>(event: EventObject, type: DeployEventType): event is DeployEvent & {
    type: DeployEventType;
};
export type DeployState = {
    value: "idle";
    context: DeployContext;
} | {
    value: "running";
    context: DeployContext;
} | {
    value: {
        running: "processing";
    };
    context: DeployContext;
} | {
    value: {
        running: "awaiting_approval";
    };
    context: DeployContext;
} | {
    value: {
        running: "awaiting_sentinel_override";
    };
    context: DeployContext;
} | {
    value: "exited";
    context: DeployContext & {
        exitCode: number;
    };
} | {
    value: "stopped";
    context: DeployContext;
};
export declare function extractVariableNameFromPrompt(line: string): string;
interface BufferedReceiverFunction {
    (output: string): void;
    /**
     * used to get the last buffer when the PTY exits to log a debug message if there's output left in there
     * (might help debugging on Windows if EOL from Nodejs doesn't work in WSL)
     */
    getBuffer: () => string;
}
export declare function bufferUnterminatedLines(handler: (output: string) => void): BufferedReceiverFunction;
export declare function handleLineReceived(send: (event: DeployEvent) => void): (output: string) => void;
export declare const deployMachine: import("xstate").StateMachine<DeployContext, any, DeployEvent, DeployState, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, DeployEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
export declare function terraformPtyService(_context: DeployContext, event: DeployEvent, spawn?: typeof spawnPty): (send: Sender<DeployEvent>, onReceive: Receiver<DeployEvent>) => void;
export declare function createAndStartDeployService(options: {
    refreshOnly?: boolean;
    parallelism: number;
    extraOptions: string[];
    terraformBinaryName: string;
    autoApprove?: boolean;
    noColor?: boolean;
    workdir: string;
    vars?: string[];
    varFiles?: string[];
}): import("xstate").Interpreter<DeployContext, any, DeployEvent, DeployState, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, DeployEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
export declare function createAndStartDestroyService(options: {
    parallelism: number;
    extraOptions: string[];
    terraformBinaryName: string;
    autoApprove?: boolean;
    noColor?: boolean;
    workdir: string;
    vars?: string[];
    varFiles?: string[];
}): import("xstate").Interpreter<DeployContext, any, DeployEvent, DeployState, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, DeployEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
export {};
//# sourceMappingURL=deploy-machine.d.ts.map