"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalProviderVersions = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const commons_1 = require("@cdktf/commons");
const fs_extra_1 = __importDefault(require("fs-extra"));
const path_1 = __importDefault(require("path"));
const cdktf_config_1 = require("./cdktf-config");
const dependency_manager_1 = require("./dependencies/dependency-manager");
// TODO: move this to @cdktf/commons
// tracked here https://github.com/hashicorp/terraform-cdk/issues/1814
/**
 * Class to help with reading `versions.json` file
 * published by `provider get` or `provider add` commands
 */
class LocalProviderVersions {
    get jsonFilePath() {
        const config = cdktf_config_1.CdktfConfig.read();
        return path_1.default.resolve(config.codeMakerOutput, "versions.json");
    }
    async readLocalVersionsJson() {
        let versionsJson;
        try {
            versionsJson = await fs_extra_1.default.readFile(this.jsonFilePath, "utf8");
        }
        catch (e) {
            // If we cannot read the versions.json file, it may not exist
            commons_1.logger.debug("versions.json file reading error: ", e);
            this.versions = undefined;
            return;
        }
        let providerVersions;
        try {
            providerVersions = JSON.parse(versionsJson);
        }
        catch (e) {
            throw commons_1.Errors.External("versions.json file is malformed. The root must be a JSON object.", e);
        }
        this.versions = Object.fromEntries(Object.entries(providerVersions).map(([providerFqn, versions]) => {
            return [
                providerFqn
                    .replace(`${dependency_manager_1.DEFAULT_HOSTNAME}/`, "")
                    .replace(`${dependency_manager_1.DEFAULT_NAMESPACE}/`, "")
                    .toLowerCase(),
                versions,
            ];
        }));
    }
    async versionsForAllProviders() {
        if (this.versions) {
            return this.versions;
        }
        await this.readLocalVersionsJson();
        return this.versions;
    }
    async versionForProvider(providerName) {
        const versions = await this.versionsForAllProviders();
        if (!versions) {
            return null;
        }
        const providerVersion = versions[providerName.toLowerCase()];
        if (!providerName) {
            return null;
        }
        return providerVersion;
    }
}
exports.LocalProviderVersions = LocalProviderVersions;
//# sourceMappingURL=data:application/json;base64,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