"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalProviderConstraints = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs_extra_1 = __importDefault(require("fs-extra"));
const path_1 = __importDefault(require("path"));
const commons_1 = require("@cdktf/commons");
const cdktf_config_1 = require("./cdktf-config");
const z = __importStar(require("zod"));
const constraintsType = z.object({
    cdktf: z.string(),
    providers: z.record(z.string()),
});
// TODO: move this to @cdktf/commons
// tracked here https://github.com/hashicorp/terraform-cdk/issues/1814
/**
 * Class to help with reading `constraints.json` file
 * published by `provider get` or `provider add` commands
 */
class LocalProviderConstraints {
    get jsonFilePath() {
        const config = cdktf_config_1.CdktfConfig.read();
        return path_1.default.resolve(config.codeMakerOutput, "constraints.json");
    }
    async readLocalConstraintsJson() {
        let constraintsJson;
        try {
            constraintsJson = await fs_extra_1.default.readFile(this.jsonFilePath, "utf8");
        }
        catch (e) {
            // If we cannot read the constraints.json file, it may not exist
            commons_1.logger.debug("constraints.json file reading error: ", e);
            this.constraints = undefined;
            return;
        }
        let providerConstraints;
        try {
            providerConstraints = constraintsType.parse(JSON.parse(constraintsJson));
            providerConstraints.providers = Object.fromEntries(Object.entries(providerConstraints.providers).map(([name, constraint]) => {
                return [name.toLowerCase(), constraint];
            }));
        }
        catch (e) {
            throw commons_1.Errors.External("constraints.json file is malformed. The root must be a JSON object.", e);
        }
        this.constraints = providerConstraints;
    }
    async constraintsForAllProviders() {
        if (this.constraints) {
            return this.constraints;
        }
        await this.readLocalConstraintsJson();
        return this.constraints;
    }
    async constraintForProvider(providerName) {
        const constraints = await this.constraintsForAllProviders();
        if (!constraints) {
            return null;
        }
        const providerConstraint = constraints.providers[providerName.toLowerCase()];
        if (!providerName) {
            return null;
        }
        return providerConstraint;
    }
}
exports.LocalProviderConstraints = LocalProviderConstraints;
//# sourceMappingURL=data:application/json;base64,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