import * as z from "zod";
declare const constraintsType: z.ZodObject<{
    cdktf: z.ZodString;
    providers: z.ZodRecord<z.ZodString, z.ZodString>;
}, "strip", z.ZodTypeAny, {
    cdktf: string;
    providers: Record<string, string>;
}, {
    cdktf: string;
    providers: Record<string, string>;
}>;
export type Constraints = z.infer<typeof constraintsType>;
/**
 * Class to help with reading `constraints.json` file
 * published by `provider get` or `provider add` commands
 */
export declare class LocalProviderConstraints {
    private constraints;
    private get jsonFilePath();
    private readLocalConstraintsJson;
    constraintsForAllProviders(): Promise<{
        cdktf: string;
        providers: Record<string, string>;
    } | undefined>;
    constraintForProvider(providerName: string): Promise<string | null>;
}
export {};
//# sourceMappingURL=local-provider-constraints.d.ts.map